/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.util.maths.structure.impl;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.infer.KInferAlg;
import org.kevoree.modeling.memory.chunk.KObjectChunk;
import org.kevoree.modeling.memory.chunk.impl.HeapObjectChunk;
import org.kevoree.modeling.memory.manager.internal.KInternalDataManager;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KMetaModel;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.util.maths.structure.KArray2D;
import org.kevoree.modeling.util.maths.structure.impl.Array2D;
import org.kevoree.modeling.util.maths.structure.impl.NativeArray2D;

public class Array2DTest {
    @Test
    public void test() {
        int i;
        int j;
        MetaModel mm = new MetaModel("test");
        KMetaClass mc = mm.addInferMetaClass("infer_class", new KInferAlg(){

            public void train(KArray2D trainingSet, KArray2D expectedResultSet, KObject currentInferObject, KInternalDataManager manager) {
            }

            public KArray2D infer(KArray2D features, KObject currentInferObject, KInternalDataManager manager) {
                return new NativeArray2D(1, 1);
            }
        });
        HeapObjectChunk segment = new HeapObjectChunk(-1L, -1L, -1L, null);
        segment.init(null, (KMetaModel)mm, mc.index());
        int nbLines = 5;
        int nbColumn = 3;
        segment.extendDoubleArray(mc.dependencies().index(), nbLines * nbColumn, mc);
        Array2D array = new Array2D(nbLines, nbColumn, 0, mc.dependencies().index(), (KObjectChunk)segment, mc);
        int count = 0;
        for (j = 0; j < nbColumn; ++j) {
            for (i = 0; i < nbLines; ++i) {
                array.set(i, j, (double)count);
                ++count;
            }
        }
        count = 0;
        for (j = 0; j < nbColumn; ++j) {
            for (i = 0; i < nbLines; ++i) {
                Assert.assertTrue((array.get(i, j) == (double)count ? 1 : 0) != 0);
                Assert.assertTrue((segment.getDoubleArrayElem(mc.dependencies().index(), count, mc) == (double)count ? 1 : 0) != 0);
                ++count;
            }
        }
        Assert.assertTrue((nbLines * nbColumn == segment.getDoubleArraySize(mc.dependencies().index(), mc) ? 1 : 0) != 0);
        double[] copyArray = segment.getDoubleArray(mc.dependencies().index(), mc);
        Assert.assertTrue((nbLines * nbColumn == copyArray.length ? 1 : 0) != 0);
    }
}

