/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.kcl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jet.Function1;
import jet.JetObject;
import jet.TypeCastException;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.kevoree.kcl.KevoreeJarClassLoader$addSubClassLoader$1;
import org.kevoree.kcl.KevoreeJarClassLoader$addWeakClassLoader$1;
import org.kevoree.kcl.KevoreeJarClassLoader$cleanupLinks$1;
import org.kevoree.kcl.KevoreeJarClassLoader$internal_loadClass$filteredLL$1;
import org.kevoree.kcl.Klassloader;
import org.kevoree.kcl.internal.KevoreeLazyJarResources;
import org.kevoree.kcl.internal.KevoreeLocalLoader;
import org.kevoree.kcl.internal.KevoreeResourcesLoader;
import org.kevoree.kcl.internal.ProxyClassLoader;
import org.kevoree.log.Log;

@JetClass(signature="Lorg/kevoree/kcl/Klassloader;", flags=16, abiVersion=6)
public class KevoreeJarClassLoader
extends Klassloader
implements JetObject {
    private KevoreeLazyJarResources classpathResources;
    private KevoreeLocalLoader local_loader;
    private final ArrayList<ProxyClassLoader> loaders = new ArrayList();
    private final ProxyClassLoader systemLoader = new SystemLoader();
    private final ProxyClassLoader parentLoader = new ParentLoader();
    private final ProxyClassLoader currentLoader = new CurrentLoader();
    private final HashMap<String, String> nativeMap;
    private ArrayList<KevoreeResourcesLoader> specialloaders;
    private boolean locked;
    private ArrayList<ClassLoader> subClassLoaders;
    private ArrayList<WeakReference<ClassLoader>> subWeakClassLoaders;
    private final ConcurrentHashMap<Integer, Integer> scoreMap;

    @Override
    @JetMethod(returnType="V")
    public void addJarFromURL(@JetValueParameter(name="child", type="?Ljava/net/URL;") URL child) {
        boolean bl = true;
        if (child == null) {
            bl = false;
        }
        if (bl) {
            this.add(child);
        } else {
            Log.error((String)"Can't add null stream");
        }
    }

    @Override
    @JetMethod(returnType="V")
    public void removeChild(@JetValueParameter(name="child", type="?Lorg/kevoree/kcl/Klassloader;") Klassloader child) {
        boolean bl = true;
        if (child == null) {
            bl = false;
        }
        if (bl) {
            this.cleanupLinks(child);
        }
    }

    @Override
    @JetMethod(returnType="V")
    public void addJarFromStream(@JetValueParameter(name="child", type="?Ljava/io/InputStream;") InputStream child) {
        boolean bl = true;
        if (child == null) {
            bl = false;
        }
        if (bl) {
            this.add(child);
        } else {
            Log.error((String)"Can't add null stream");
        }
    }

    @Override
    @JetMethod(returnType="V")
    public void addChild(@JetValueParameter(name="child", type="?Lorg/kevoree/kcl/Klassloader;") Klassloader child) {
        boolean bl = true;
        if (child == null) {
            bl = false;
        }
        if (bl) {
            this.addSubClassLoader(child);
        } else {
            Log.error((String)"Can't add null child classloader");
        }
    }

    @JetMethod(flags=33, propertyType="?Lorg/kevoree/kcl/internal/KevoreeLazyJarResources;")
    protected final KevoreeLazyJarResources getClasspathResources() {
        return this.classpathResources;
    }

    @JetMethod(flags=33, propertyType="?Lorg/kevoree/kcl/internal/KevoreeLazyJarResources;")
    protected final void setClasspathResources(@JetValueParameter(name="<set-?>", type="?Lorg/kevoree/kcl/internal/KevoreeLazyJarResources;") KevoreeLazyJarResources kevoreeLazyJarResources) {
        this.classpathResources = kevoreeLazyJarResources;
    }

    @JetMethod(flags=33, propertyType="?Lorg/kevoree/kcl/internal/KevoreeLocalLoader;")
    protected final KevoreeLocalLoader getLocal_loader() {
        return this.local_loader;
    }

    @JetMethod(flags=33, propertyType="?Lorg/kevoree/kcl/internal/KevoreeLocalLoader;")
    protected final void setLocal_loader(@JetValueParameter(name="<set-?>", type="?Lorg/kevoree/kcl/internal/KevoreeLocalLoader;") KevoreeLocalLoader kevoreeLocalLoader) {
        this.local_loader = kevoreeLocalLoader;
    }

    @JetMethod(flags=33, propertyType="Ljava/util/ArrayList<Lorg/kevoree/kcl/internal/ProxyClassLoader;>;")
    protected final ArrayList<ProxyClassLoader> getLoaders() {
        return this.loaders;
    }

    @JetMethod(flags=9, propertyType="Lorg/kevoree/kcl/internal/ProxyClassLoader;")
    private final ProxyClassLoader getSystemLoader() {
        return this.systemLoader;
    }

    @JetMethod(flags=9, propertyType="Lorg/kevoree/kcl/internal/ProxyClassLoader;")
    private final ProxyClassLoader getParentLoader() {
        return this.parentLoader;
    }

    @JetMethod(flags=9, propertyType="Lorg/kevoree/kcl/internal/ProxyClassLoader;")
    private final ProxyClassLoader getCurrentLoader() {
        return this.currentLoader;
    }

    @Override
    @JetMethod(returnType="V")
    public void isolateFromSystem() {
        this.loaders.clear();
        KevoreeLocalLoader kevoreeLocalLoader = this.local_loader;
        if (kevoreeLocalLoader == null) {
            Intrinsics.throwNpe();
        }
        this.loaders.add(kevoreeLocalLoader);
        Collections.sort((List)this.loaders);
    }

    @JetMethod(flags=9, propertyType="Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/String;>;")
    private final HashMap<String, String> getNativeMap() {
        return this.nativeMap;
    }

    @JetMethod(flags=16, returnType="V")
    public final void addNativeMapping(@JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="url", type="Ljava/lang/String;") String url) {
        this.nativeMap.put(name, url);
    }

    @Override
    @JetMethod(flags=32, returnType="?Ljava/lang/String;")
    protected String findLibrary(@JetValueParameter(name="p1", type="?Ljava/lang/String;") String p1) {
        return this.nativeMap.containsKey(p1) ? this.nativeMap.get(p1) : super.findLibrary(p1);
    }

    @JetMethod(flags=16, returnType="Ljet/List<Ljava/net/URL;>;")
    public final List<URL> getLoadedURLs() {
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        return kevoreeLazyJarResources.getLoadedURLs();
    }

    @JetMethod(flags=16, returnType="Ljet/List<Ljava/net/URL;>;")
    public final List<URL> getLinkedLoadedURLs() {
        ArrayList resultURL = new ArrayList();
        ArrayList alreadyPassed = new ArrayList();
        this.internal_getAllLoadedURLs(resultURL, alreadyPassed);
        return resultURL;
    }

    @JetMethod(flags=16, returnType="V")
    public final void internal_getAllLoadedURLs(@JetValueParameter(name="res", type="Ljet/MutableList<Ljava/net/URL;>;") List<URL> res, @JetValueParameter(name="cls", type="Ljet/MutableList<Ljava/lang/ClassLoader;>;") List<ClassLoader> cls) {
        cls.add(this);
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        res.addAll((Collection<URL>)kevoreeLazyJarResources.getLoadedURLs());
        for (ClassLoader l : this.subClassLoaders) {
            boolean bl = l instanceof KevoreeJarClassLoader ? !cls.contains(l) : false;
            if (!bl) continue;
            ClassLoader classLoader = l;
            if (classLoader == null) {
                throw new TypeCastException("java.lang.ClassLoader cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
            }
            ((KevoreeJarClassLoader)classLoader).internal_getAllLoadedURLs(res, cls);
        }
    }

    @JetMethod(flags=17, propertyType="Ljava/util/ArrayList<Lorg/kevoree/kcl/internal/KevoreeResourcesLoader;>;")
    public final ArrayList<KevoreeResourcesLoader> getSpecialloaders() {
        return this.specialloaders;
    }

    @JetMethod(flags=17, propertyType="Ljava/util/ArrayList<Lorg/kevoree/kcl/internal/KevoreeResourcesLoader;>;")
    public final void setSpecialloaders(@JetValueParameter(name="<set-?>", type="Ljava/util/ArrayList<Lorg/kevoree/kcl/internal/KevoreeResourcesLoader;>;") ArrayList<KevoreeResourcesLoader> arrayList) {
        this.specialloaders = arrayList;
    }

    @JetMethod(flags=32, returnType="V")
    protected final void addSpecialLoaders(@JetValueParameter(name="l", type="Lorg/kevoree/kcl/internal/KevoreeResourcesLoader;") KevoreeResourcesLoader l) {
        this.specialloaders.add(l);
    }

    @JetMethod(flags=16, returnType="Ljava/util/ArrayList<Lorg/kevoree/kcl/internal/KevoreeResourcesLoader;>;")
    public final ArrayList<KevoreeResourcesLoader> getSpecialLoaders() {
        return this.specialloaders;
    }

    @JetMethod(flags=9, propertyType="Z")
    private final boolean getLocked() {
        return this.locked;
    }

    @JetMethod(flags=9, propertyType="Z")
    private final void setLocked(@JetValueParameter(name="<set-?>", type="Z") boolean bl) {
        this.locked = bl;
    }

    @JetMethod(flags=16, returnType="V")
    public final void lockLinks() {
        this.locked = 1;
    }

    @JetMethod(flags=33, propertyType="Ljava/util/ArrayList<Ljava/lang/ClassLoader;>;")
    protected final ArrayList<ClassLoader> getSubClassLoaders() {
        return this.subClassLoaders;
    }

    @JetMethod(flags=33, propertyType="Ljava/util/ArrayList<Ljava/lang/ClassLoader;>;")
    protected final void setSubClassLoaders(@JetValueParameter(name="<set-?>", type="Ljava/util/ArrayList<Ljava/lang/ClassLoader;>;") ArrayList<ClassLoader> arrayList) {
        this.subClassLoaders = arrayList;
    }

    @JetMethod(flags=16, returnType="V")
    public final void cleanupLinks(@JetValueParameter(name="c", type="Ljava/lang/ClassLoader;") ClassLoader c) {
        this.subClassLoaders.remove(c);
        this.subWeakClassLoaders.removeAll(KotlinPackage.filter((Collection)this.subWeakClassLoaders, (Function1)((Function1)new KevoreeJarClassLoader$cleanupLinks$1(c))));
    }

    @JetMethod(flags=33, propertyType="Ljava/util/ArrayList<Ljava/lang/ref/WeakReference<Ljava/lang/ClassLoader;>;>;")
    protected final ArrayList<WeakReference<ClassLoader>> getSubWeakClassLoaders() {
        return this.subWeakClassLoaders;
    }

    @JetMethod(flags=33, propertyType="Ljava/util/ArrayList<Ljava/lang/ref/WeakReference<Ljava/lang/ClassLoader;>;>;")
    protected final void setSubWeakClassLoaders(@JetValueParameter(name="<set-?>", type="Ljava/util/ArrayList<Ljava/lang/ref/WeakReference<Ljava/lang/ClassLoader;>;>;") ArrayList<WeakReference<ClassLoader>> arrayList) {
        this.subWeakClassLoaders = arrayList;
    }

    @JetMethod(flags=16, returnType="V")
    public void setLazyLoad(@JetValueParameter(name="lazyload", type="Z") boolean lazyload) {
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        kevoreeLazyJarResources.setLazyLoad(lazyload);
    }

    @JetMethod(flags=16, returnType="Ljet/List<Ljava/lang/ClassLoader;>;")
    public final List<ClassLoader> getSubClassLoaders() {
        return this.subClassLoaders;
    }

    @JetMethod(flags=16, returnType="V")
    public final void addSubClassLoader(@JetValueParameter(name="cl", type="Ljava/lang/ClassLoader;") ClassLoader cl) {
        if (!(this.locked || this.subClassLoaders.contains(cl) || KotlinPackage.any((Iterable)this.subWeakClassLoaders, (Function1)((Function1)new KevoreeJarClassLoader$addSubClassLoader$1(cl))))) {
            this.subClassLoaders.add(cl);
        }
    }

    @JetMethod(flags=16, returnType="V")
    public final void addWeakClassLoader(@JetValueParameter(name="wcl", type="Ljava/lang/ClassLoader;") ClassLoader wcl) {
        if (!(this.locked || this.subClassLoaders.contains(wcl) || KotlinPackage.any((Iterable)this.subWeakClassLoaders, (Function1)((Function1)new KevoreeJarClassLoader$addWeakClassLoader$1(wcl))))) {
            this.subWeakClassLoaders.add(new WeakReference<ClassLoader>(wcl));
        }
    }

    @JetMethod(flags=32, returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
    protected final Class<? extends Object> callSuperConcreteLoader(@JetValueParameter(name="className", type="Ljava/lang/String;") String className, @JetValueParameter(name="resolveIt", type="Z") boolean resolveIt) {
        Class clazz = null;
        for (ProxyClassLoader l : this.loaders) {
            if (!l.isEnabled()) continue;
            clazz = l.loadClass(className, resolveIt);
            boolean bl = true;
            if (clazz == null) {
                bl = false;
            }
            if (!bl) continue;
            return clazz;
        }
        return clazz;
    }

    @JetMethod(flags=32, returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
    protected Class<? extends Object> loadClass(@JetValueParameter(name="className", type="?Ljava/lang/String;") String className, @JetValueParameter(name="resolveIt", type="Z") boolean resolveIt) {
        String string = className;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Class<? extends Object> result = this.internal_loadClass(string, resolveIt);
        boolean bl = true;
        if (result != null) {
            bl = false;
        }
        if (bl) {
            throw (Throwable)new ClassNotFoundException(className);
        }
        return result;
    }

    @JetMethod(flags=9, propertyType="Ljava/util/concurrent/ConcurrentHashMap<Ljava/lang/Integer;Ljava/lang/Integer;>;")
    private final ConcurrentHashMap<Integer, Integer> getScoreMap() {
        return this.scoreMap;
    }

    @JetMethod(flags=8, returnType="I")
    private final int getScore(@JetValueParameter(name="kcl", type="Ljava/lang/ClassLoader;") ClassLoader kcl) {
        int n;
        if (this.scoreMap.containsKey(kcl.hashCode())) {
            Integer n2 = this.scoreMap.get(kcl.hashCode());
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            n = ((Number)n2).intValue();
        } else {
            n = 0;
        }
        return n;
    }

    @JetMethod(flags=8, returnType="I")
    private final int incScore(@JetValueParameter(name="kcl", type="Ljava/lang/ClassLoader;") ClassLoader kcl) {
        this.scoreMap.put(kcl.hashCode(), this.getScore(kcl) + 1);
        Integer n = this.scoreMap.get(kcl.hashCode());
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return ((Number)n).intValue();
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
    public final Class<? extends Object> internal_loadClass(@JetValueParameter(name="className", type="Ljava/lang/String;") String className, @JetValueParameter(name="resolveIt", type="Z") boolean resolveIt) {
        Class<? extends Object> result = null;
        result = this.callSuperConcreteLoader(className, resolveIt);
        boolean bl = true;
        if (result == null) {
            bl = false;
        }
        if (bl) {
            return result;
        }
        if (resolveIt) {
            List sortedL2 = KotlinPackage.sort((Iterable)this.subClassLoaders, (Comparator)new Comparator<ClassLoader>(this){
                final /* synthetic */ KevoreeJarClassLoader this$0;

                @JetMethod(returnType="Z")
                public boolean equals(@JetValueParameter(name="p0", type="?Ljava/lang/Object;") Object p0) {
                    throw (Throwable)new UnsupportedOperationException();
                }

                @JetMethod(returnType="I")
                public int compare(@JetValueParameter(name="p0", type="Ljava/lang/ClassLoader;") ClassLoader p0, @JetValueParameter(name="p1", type="Ljava/lang/ClassLoader;") ClassLoader p1) {
                    if (KevoreeJarClassLoader.getScore$b$0(this.this$0, p0) == KevoreeJarClassLoader.getScore$b$0(this.this$0, p1)) {
                        return 0;
                    }
                    if (KevoreeJarClassLoader.getScore$b$0(this.this$0, p0) > KevoreeJarClassLoader.getScore$b$0(this.this$0, p1)) {
                        return 1;
                    }
                    return -1;
                }
                {
                    this.this$0 = $outer;
                }
            });
            for (ClassLoader subCL : sortedL2) {
                Class<? extends Object> result2 = null;
                if (subCL instanceof KevoreeJarClassLoader) {
                    ClassLoader classLoader = subCL;
                    if (classLoader == null) {
                        throw new TypeCastException("java.lang.ClassLoader cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                    }
                    result2 = ((KevoreeJarClassLoader)classLoader).internal_loadClass(className, false);
                } else {
                    Class clazz;
                    try {
                        clazz = subCL.loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = null;
                    }
                }
                boolean bl2 = true;
                if (result2 == null) {
                    bl2 = false;
                }
                if (!bl2) continue;
                this.incScore(subCL);
                return result2;
            }
            List filteredLL2 = KotlinPackage.sort((Iterable)KotlinPackage.filter((Collection)this.subWeakClassLoaders, (Function1)((Function1)KevoreeJarClassLoader$internal_loadClass$filteredLL$1.instance$)), (Comparator)new Comparator<WeakReference<ClassLoader>>(this){
                final /* synthetic */ KevoreeJarClassLoader this$0;

                @JetMethod(returnType="I")
                public int compare(@JetValueParameter(name="p0", type="Ljava/lang/ref/WeakReference<Ljava/lang/ClassLoader;>;") WeakReference<ClassLoader> p0, @JetValueParameter(name="p1", type="Ljava/lang/ref/WeakReference<Ljava/lang/ClassLoader;>;") WeakReference<ClassLoader> p1) {
                    ClassLoader classLoader = (ClassLoader)p0.get();
                    if (classLoader == null) {
                        Intrinsics.throwNpe();
                    }
                    int n = KevoreeJarClassLoader.getScore$b$0(this.this$0, classLoader);
                    ClassLoader classLoader2 = (ClassLoader)p1.get();
                    if (classLoader2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (n == KevoreeJarClassLoader.getScore$b$0(this.this$0, classLoader2)) {
                        return 0;
                    }
                    ClassLoader classLoader3 = (ClassLoader)p0.get();
                    if (classLoader3 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n2 = KevoreeJarClassLoader.getScore$b$0(this.this$0, classLoader3);
                    ClassLoader classLoader4 = (ClassLoader)p1.get();
                    if (classLoader4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (n2 > KevoreeJarClassLoader.getScore$b$0(this.this$0, classLoader4)) {
                        return 1;
                    }
                    return -1;
                }

                @JetMethod(returnType="Z")
                public boolean equals(@JetValueParameter(name="p0", type="?Ljava/lang/Object;") Object p0) {
                    throw (Throwable)new UnsupportedOperationException();
                }
                {
                    this.this$0 = $outer;
                }
            });
            for (WeakReference subCL : filteredLL2) {
                try {
                    boolean bl3 = true;
                    if ((ClassLoader)subCL.get() == null) {
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    Class<? extends Object> result3 = null;
                    if ((ClassLoader)subCL.get() instanceof KevoreeJarClassLoader) {
                        ClassLoader classLoader = (ClassLoader)subCL.get();
                        if (classLoader == null) {
                            throw new TypeCastException("java.lang.ClassLoader? cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                        }
                        result3 = ((KevoreeJarClassLoader)classLoader).internal_loadClass(className, false);
                    } else {
                        Class<?> clazz;
                        try {
                            ClassLoader classLoader = (ClassLoader)subCL.get();
                            if (classLoader == null) {
                                Intrinsics.throwNpe();
                            }
                            clazz = classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            clazz = null;
                        }
                    }
                    boolean bl4 = true;
                    if (result3 == null) {
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    ClassLoader classLoader = (ClassLoader)subCL.get();
                    if (classLoader == null) {
                        Intrinsics.throwNpe();
                    }
                    this.incScore(classLoader);
                    return result3;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return result;
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
    public final Class<? extends Object> getLoadedClass(@JetValueParameter(name="className", type="Ljava/lang/String;") String className) {
        return this.findLoadedClass(className);
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
    public Class<? extends Object> internal_defineClass(@JetValueParameter(name="className", type="Ljava/lang/String;") String className, @JetValueParameter(name="bytes", type="[B") byte[] bytes) {
        if (KotlinPackage.contains((String)className, (CharSequence)".")) {
            String packageName = KotlinPackage.substring((String)className, (int)0, (int)KotlinPackage.lastIndexOf((String)className, (char)'.'));
            boolean bl = true;
            if (this.getPackage(packageName) != null) {
                bl = false;
            }
            if (bl) {
                Object object;
                try {
                    object = this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (Throwable throwable) {
                    Log.debug((String)"Error while defining packge ", (Throwable)throwable);
                    object = Unit.VALUE;
                }
            }
        }
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    @JetMethod(returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
    public Class<? extends Object> loadClass(@JetValueParameter(name="className", type="?Ljava/lang/String;") String className) {
        return this.loadClass(className, true);
    }

    @Override
    @JetMethod(returnType="?Ljava/io/InputStream;")
    public InputStream getResourceAsStream(@JetValueParameter(name="name", type="?Ljava/lang/String;") String name) {
        InputStream resolved = this.internal_getResourceAsStream(name);
        boolean bl = true;
        if (resolved == null) {
            bl = false;
        }
        if (bl) {
            return resolved;
        }
        for (ClassLoader classLoader : this.subClassLoaders) {
            InputStream inputStream;
            if (classLoader instanceof KevoreeJarClassLoader) {
                ClassLoader classLoader2 = classLoader;
                if (classLoader2 == null) {
                    throw new TypeCastException("java.lang.ClassLoader cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                }
                inputStream = ((KevoreeJarClassLoader)classLoader2).internal_getResourceAsStream(name);
            } else {
                inputStream = classLoader.getResourceAsStream(name);
            }
            resolved = inputStream;
            boolean bl2 = true;
            if (resolved == null) {
                bl2 = false;
            }
            if (!bl2) continue;
            return resolved;
        }
        for (WeakReference weakReference : this.subWeakClassLoaders) {
            InputStream inputStream;
            boolean bl3 = true;
            if ((ClassLoader)weakReference.get() == null) {
                bl3 = false;
            }
            if (!bl3) continue;
            ClassLoader sub = (ClassLoader)weakReference.get();
            if (sub instanceof KevoreeJarClassLoader) {
                ClassLoader classLoader = sub;
                if (classLoader == null) {
                    throw new TypeCastException("java.lang.ClassLoader? cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                }
                inputStream = ((KevoreeJarClassLoader)classLoader).internal_getResourceAsStream(name);
            } else {
                ClassLoader classLoader = sub;
                inputStream = classLoader != null ? classLoader.getResourceAsStream(name) : null;
            }
            resolved = inputStream;
            boolean bl4 = true;
            if (resolved == null) {
                bl4 = false;
            }
            if (!bl4) continue;
            return resolved;
        }
        return resolved;
    }

    @JetMethod(flags=16, returnType="?Ljava/io/InputStream;")
    public final InputStream internal_getResourceAsStream(@JetValueParameter(name="name", type="?Ljava/lang/String;") String name) {
        InputStream inputStream;
        String string = name;
        Boolean bl = string != null ? Boolean.valueOf(KotlinPackage.endsWith((String)string, (String)".class")) : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (bl.booleanValue()) {
            byte[] byArray;
            boolean bl2 = true;
            if (name == null) {
                bl2 = false;
            }
            if (bl2) {
                KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
                if (kevoreeLazyJarResources == null) {
                    Intrinsics.throwNpe();
                }
                byArray = kevoreeLazyJarResources.getResource(name);
            } else {
                byArray = null;
            }
            byte[] res = byArray;
            boolean bl3 = true;
            if (res == null) {
                bl3 = false;
            }
            if (bl3) {
                return new ByteArrayInputStream(res);
            }
        }
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        String string2 = name;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        URL url = kevoreeLazyJarResources.getResourceURL(string2);
        boolean bl4 = true;
        if (url == null) {
            bl4 = false;
        }
        if (bl4) {
            if (KotlinPackage.startsWith((String)url.toString(), (String)"file:kclstream:")) {
                KevoreeLazyJarResources kevoreeLazyJarResources2 = this.classpathResources;
                if (kevoreeLazyJarResources2 == null) {
                    throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
                }
                byte[] byArray = kevoreeLazyJarResources2.getResourceContent(url);
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                inputStream = new ByteArrayInputStream(byArray);
            } else {
                inputStream = url.openStream();
            }
        } else {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    @JetMethod(returnType="?Ljava/net/URL;")
    public URL getResource(@JetValueParameter(name="s", type="?Ljava/lang/String;") String s) {
        return this.findResource(s);
    }

    @JetMethod(flags=16, returnType="?Ljava/net/URL;")
    public final URL internal_getResource(@JetValueParameter(name="s", type="Ljava/lang/String;") String s) {
        URL uRL;
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        if (kevoreeLazyJarResources.containResource(s)) {
            KevoreeLazyJarResources kevoreeLazyJarResources2 = this.classpathResources;
            if (kevoreeLazyJarResources2 == null) {
                throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
            }
            if (KotlinPackage.startsWith((String)String.valueOf(kevoreeLazyJarResources2.getResourceURL(s)), (String)"file:kclstream:")) {
                String cleanName = KotlinPackage.contains((String)s, (CharSequence)"/") ? KotlinPackage.substring((String)s, (int)(KotlinPackage.lastIndexOf((String)s, (String)"/") + 1)) : s;
                File tFile = File.createTempFile("dummy_kcl_temp", cleanName);
                tFile.deleteOnExit();
                FileOutputStream tWriter = new FileOutputStream(tFile);
                KevoreeLazyJarResources kevoreeLazyJarResources3 = this.classpathResources;
                if (kevoreeLazyJarResources3 == null) {
                    throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
                }
                KevoreeLazyJarResources kevoreeLazyJarResources4 = this.classpathResources;
                if (kevoreeLazyJarResources4 == null) {
                    throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
                }
                URL uRL2 = kevoreeLazyJarResources4.getResourceURL(s);
                if (uRL2 == null) {
                    Intrinsics.throwNpe();
                }
                byte[] byArray = kevoreeLazyJarResources3.getResourceContent(uRL2);
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                tWriter.write(byArray);
                tWriter.close();
                uRL = new URL("file:///" + tFile.getAbsolutePath());
            } else {
                KevoreeLazyJarResources kevoreeLazyJarResources5 = this.classpathResources;
                if (kevoreeLazyJarResources5 == null) {
                    throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
                }
                uRL = kevoreeLazyJarResources5.getResourceURL(s);
            }
        } else {
            uRL = null;
        }
        return uRL;
    }

    @JetMethod(flags=16, returnType="V")
    public void unload() {
    }

    @Override
    @JetMethod(flags=32, returnType="?Ljava/net/URL;")
    protected URL findResource(@JetValueParameter(name="s", type="?Ljava/lang/String;") String s) {
        URL uRL;
        String string = s;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        URL urlInternal = this.internal_getResource(string);
        boolean bl = true;
        if (urlInternal != null) {
            bl = false;
        }
        if (bl) {
            for (ClassLoader classLoader : this.subClassLoaders) {
                URL uRL2;
                if (classLoader instanceof KevoreeJarClassLoader) {
                    ClassLoader classLoader2 = classLoader;
                    if (classLoader2 == null) {
                        throw new TypeCastException("java.lang.ClassLoader cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                    }
                    uRL2 = ((KevoreeJarClassLoader)classLoader2).internal_getResource(s);
                } else {
                    uRL2 = classLoader.getResource(s);
                }
                urlInternal = uRL2;
                boolean bl2 = true;
                if (urlInternal == null) {
                    bl2 = false;
                }
                if (!bl2) continue;
                return urlInternal;
            }
            for (WeakReference weakReference : this.subWeakClassLoaders) {
                URL uRL3;
                boolean bl3 = true;
                if ((ClassLoader)weakReference.get() == null) {
                    bl3 = false;
                }
                if (!bl3) continue;
                ClassLoader sub = (ClassLoader)weakReference.get();
                if (sub instanceof KevoreeJarClassLoader) {
                    ClassLoader classLoader = sub;
                    if (classLoader == null) {
                        throw new TypeCastException("java.lang.ClassLoader? cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                    }
                    uRL3 = ((KevoreeJarClassLoader)classLoader).internal_getResource(s);
                } else {
                    ClassLoader classLoader = sub;
                    uRL3 = classLoader != null ? classLoader.getResource(s) : null;
                }
                urlInternal = uRL3;
                boolean bl4 = true;
                if (urlInternal == null) {
                    bl4 = false;
                }
                if (!bl4) continue;
                return urlInternal;
            }
            uRL = null;
        } else {
            uRL = urlInternal;
        }
        return uRL;
    }

    /*
     * WARNING - void declaration
     */
    @JetMethod(flags=16, returnType="Ljava/util/ArrayList<Ljava/net/URL;>;")
    public final ArrayList<URL> internal_findResources(@JetValueParameter(name="p1", type="Ljava/lang/String;") String p1) {
        ArrayList<URL> arrayList;
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        if (kevoreeLazyJarResources.containResource(p1)) {
            void var3_3;
            KevoreeLazyJarResources kevoreeLazyJarResources2 = this.classpathResources;
            if (kevoreeLazyJarResources2 == null) {
                throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
            }
            List<URL> urls = kevoreeLazyJarResources2.getResourceURLS(p1);
            ArrayList<URL> resolvedUrl = new ArrayList<URL>();
            for (URL u : urls) {
                boolean bl;
                if (KotlinPackage.startsWith((String)u.toString(), (String)"file:kclstream:")) {
                    String cleanName = KotlinPackage.contains((String)p1, (CharSequence)"/") ? KotlinPackage.substring((String)p1, (int)(KotlinPackage.lastIndexOf((String)p1, (String)"/") + 1)) : p1;
                    File tFile = File.createTempFile("dummy_kcl_temp", cleanName);
                    tFile.deleteOnExit();
                    FileOutputStream tWriter = new FileOutputStream(tFile);
                    KevoreeLazyJarResources kevoreeLazyJarResources3 = this.classpathResources;
                    if (kevoreeLazyJarResources3 == null) {
                        throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
                    }
                    byte[] byArray = kevoreeLazyJarResources3.getResourceContent(u);
                    if (byArray == null) {
                        Intrinsics.throwNpe();
                    }
                    tWriter.write(byArray);
                    tWriter.close();
                    bl = resolvedUrl.add(new URL("file:///" + tFile.getAbsolutePath()));
                    continue;
                }
                bl = resolvedUrl.add(u);
            }
            arrayList = var3_3;
        } else {
            arrayList = new ArrayList<URL>();
        }
        return arrayList;
    }

    @Override
    @JetMethod(flags=32, returnType="Ljava/util/Enumeration<Ljava/net/URL;>;")
    protected Enumeration<URL> findResources(@JetValueParameter(name="p1", type="?Ljava/lang/String;") String p1) {
        String string = p1;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        List selfRes = this.internal_findResources(string);
        for (ClassLoader classLoader : this.subClassLoaders) {
            Enumeration<URL> subEnum;
            Enumeration<URL> enumeration;
            if (classLoader instanceof KevoreeJarClassLoader) {
                ClassLoader classLoader2 = classLoader;
                if (classLoader2 == null) {
                    throw new TypeCastException("java.lang.ClassLoader cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                }
                enumeration = Collections.enumeration((Collection)((KevoreeJarClassLoader)classLoader2).internal_findResources(p1));
            } else {
                enumeration = subEnum = classLoader.getResources(p1);
            }
            while (subEnum.hasMoreElements()) {
                URL subElem = subEnum.nextElement();
                if (selfRes.contains(subElem)) continue;
                URL uRL = subElem;
                if (uRL == null) {
                    throw new TypeCastException("java.net.URL cannot be cast to java.net.URL");
                }
                selfRes.add(uRL);
            }
        }
        block2: for (WeakReference weakReference : this.subWeakClassLoaders) {
            Enumeration<URL> enumeration;
            boolean bl = true;
            if ((ClassLoader)weakReference.get() == null) {
                bl = false;
            }
            if (!bl) continue;
            ClassLoader sub = (ClassLoader)weakReference.get();
            if (sub instanceof KevoreeJarClassLoader) {
                ClassLoader classLoader = sub;
                if (classLoader == null) {
                    throw new TypeCastException("java.lang.ClassLoader? cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
                }
                enumeration = Collections.enumeration((Collection)((KevoreeJarClassLoader)classLoader).internal_findResources(p1));
            } else {
                ClassLoader classLoader = sub;
                enumeration = classLoader != null ? classLoader.getResources(p1) : null;
            }
            Enumeration<URL> subEnum = enumeration;
            while (true) {
                Enumeration<URL> enumeration2 = subEnum;
                if (enumeration2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!enumeration2.hasMoreElements()) continue block2;
                URL subElem = subEnum.nextElement();
                if (selfRes.contains(subElem)) continue;
                URL uRL = subElem;
                if (uRL == null) {
                    throw new TypeCastException("java.net.URL cannot be cast to java.net.URL");
                }
                selfRes.add(uRL);
            }
        }
        return Collections.enumeration(selfRes);
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String cleanJarURL(@JetValueParameter(name="j", type="Ljava/lang/String;") String j) {
        return KotlinPackage.contains((String)j, (CharSequence)File.separator) ? KotlinPackage.substring((String)j, (int)(KotlinPackage.lastIndexOf((String)j, (String)File.separator) + 1)) : j;
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String getKCLDump() {
        StringBuffer buffer = new StringBuffer();
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        buffer.append("\tJar=" + this.cleanJarURL(kevoreeLazyJarResources.getLastLoadedJar()) + "_" + this.hashCode() + "\n");
        Iterator<Object> iterator = this.subClassLoaders.iterator();
        while (iterator.hasNext()) {
            ClassLoader classLoader;
            ClassLoader classLoader2 = classLoader = iterator.next();
            if (classLoader2 == null) {
                throw new TypeCastException("java.lang.ClassLoader cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
            }
            KevoreeLazyJarResources kevoreeLazyJarResources2 = ((KevoreeJarClassLoader)classLoader2).classpathResources;
            if (kevoreeLazyJarResources2 == null) {
                throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
            }
            buffer.append("\t\tl->" + this.cleanJarURL(kevoreeLazyJarResources2.getLastLoadedJar()) + "_" + ((KevoreeJarClassLoader)classLoader).hashCode() + "\n");
        }
        for (WeakReference weakReference : this.subWeakClassLoaders) {
            boolean bl = true;
            if ((ClassLoader)weakReference.get() == null) {
                bl = false;
            }
            if (!bl) continue;
            StringBuilder stringBuilder = new StringBuilder().append((Object)"\t\tw~>");
            ClassLoader classLoader = (ClassLoader)weakReference.get();
            if (classLoader == null) {
                throw new TypeCastException("java.lang.ClassLoader? cannot be cast to org.kevoree.kcl.KevoreeJarClassLoader");
            }
            KevoreeLazyJarResources kevoreeLazyJarResources3 = ((KevoreeJarClassLoader)classLoader).classpathResources;
            if (kevoreeLazyJarResources3 == null) {
                throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
            }
            StringBuilder stringBuilder2 = new StringBuilder().append((Object)kevoreeLazyJarResources3.getLastLoadedJar()).append((Object)"_");
            ClassLoader classLoader3 = (ClassLoader)weakReference.get();
            if (classLoader3 == null) {
                Intrinsics.throwNpe();
            }
            buffer.append(stringBuilder.append((Object)this.cleanJarURL(stringBuilder2.append(classLoader3.hashCode()).toString())).append((Object)"\n").toString());
        }
        return buffer.toString();
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public String toString() {
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        if (kevoreeLazyJarResources == null) {
            throw new TypeCastException("org.kevoree.kcl.internal.KevoreeLazyJarResources? cannot be cast to org.kevoree.kcl.internal.KevoreeLazyJarResources");
        }
        return this.cleanJarURL(kevoreeLazyJarResources.getLastLoadedJar()).toString() + this.hashCode();
    }

    @JetMethod(returnType="V")
    public final void add(@JetValueParameter(name="resourceName", type="Ljava/lang/String;") String resourceName) {
        block0: {
            KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
            if (kevoreeLazyJarResources == null) break block0;
            kevoreeLazyJarResources.loadJar(resourceName);
        }
    }

    @JetMethod(returnType="V")
    public final void add(@JetValueParameter(name="jarStream", type="Ljava/io/InputStream;") InputStream jarStream) {
        block0: {
            KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
            if (kevoreeLazyJarResources == null) break block0;
            kevoreeLazyJarResources.loadJar(jarStream);
        }
    }

    @JetMethod(returnType="V")
    public final void add(@JetValueParameter(name="url", type="Ljava/net/URL;") URL url) {
        block0: {
            KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
            if (kevoreeLazyJarResources == null) break block0;
            kevoreeLazyJarResources.loadJar(url);
        }
    }

    @JetMethod(returnType="?[B")
    public byte[] loadClassBytes(@JetValueParameter(name="className", type="Ljava/lang/String;") String className) {
        String className2 = this.formatClassName(className);
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources;
        return (byte[])(kevoreeLazyJarResources != null ? kevoreeLazyJarResources.getResource(className2) : null);
    }

    @JetMethod(flags=16, returnType="Ljava/lang/String;")
    public final String formatClassName(@JetValueParameter(name="className", type="Ljava/lang/String;") String className) {
        String classNameT = KotlinPackage.replace((String)className, (char)'/', (char)'~');
        classNameT = KotlinPackage.replace((String)classNameT, (char)'.', (char)'/') + ".class";
        classNameT = KotlinPackage.replace((String)classNameT, (char)'~', (char)'/');
        return classNameT;
    }

    @JetMethod(flags=16, returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
    public final Class<? extends Object> callCLfindSystemClass(@JetValueParameter(name="className", type="?Ljava/lang/String;") String className) {
        return this.findSystemClass(className);
    }

    @JetConstructor
    public KevoreeJarClassLoader() {
        KevoreeLazyJarResources kevoreeLazyJarResources = this.classpathResources = new KevoreeLazyJarResources(this);
        if (kevoreeLazyJarResources == null) {
            Intrinsics.throwNpe();
        }
        this.local_loader = new KevoreeLocalLoader(kevoreeLazyJarResources, this);
        this.loaders.add(this.systemLoader);
        this.loaders.add(this.parentLoader);
        this.loaders.add(this.currentLoader);
        KevoreeLocalLoader kevoreeLocalLoader = this.local_loader;
        if (kevoreeLocalLoader == null) {
            Intrinsics.throwNpe();
        }
        this.loaders.add(kevoreeLocalLoader);
        Collections.sort((List)this.loaders);
        this.nativeMap = new HashMap();
        this.specialloaders = new ArrayList();
        this.subClassLoaders = new ArrayList();
        this.subWeakClassLoaders = new ArrayList();
        this.scoreMap = new ConcurrentHashMap();
    }

    public static final /* synthetic */ int getScore$b$0(KevoreeJarClassLoader $this, ClassLoader kcl) {
        return $this.getScore(kcl);
    }

    @JetClass(signature="Lorg/kevoree/kcl/internal/ProxyClassLoader;", flags=16, abiVersion=6)
    public final class CurrentLoader
    extends ProxyClassLoader
    implements JetObject {
        @Override
        @JetMethod(returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
        public Class<? extends Object> loadClass(@JetValueParameter(name="className", type="?Ljava/lang/String;") String className, @JetValueParameter(name="resolveIt", type="Z") boolean resolveIt) {
            Class<?> result = null;
            try {
                ClassLoader classLoader = KevoreeJarClassLoader.this.getClass().getClassLoader();
                if (classLoader == null) {
                    Intrinsics.throwNpe();
                }
                result = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            return result;
        }

        @Override
        @JetMethod(returnType="?Ljava/io/InputStream;")
        public InputStream loadResource(@JetValueParameter(name="name", type="?Ljava/lang/String;") String name) {
            ClassLoader classLoader = KevoreeJarClassLoader.this.getClass().getClassLoader();
            if (classLoader == null) {
                Intrinsics.throwNpe();
            }
            InputStream isS = classLoader.getResourceAsStream(name);
            boolean bl = true;
            if (isS == null) {
                bl = false;
            }
            if (bl) {
                return isS;
            }
            return null;
        }

        @JetConstructor
        public CurrentLoader() {
            this.order = 2;
        }
    }

    @JetClass(signature="Lorg/kevoree/kcl/internal/ProxyClassLoader;", flags=16, abiVersion=6)
    public static final class ThreadContextLoader
    extends ProxyClassLoader
    implements JetObject {
        @Override
        @JetMethod(returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
        public Class<? extends Object> loadClass(@JetValueParameter(name="className", type="?Ljava/lang/String;") String className, @JetValueParameter(name="resolveIt", type="Z") boolean resolveIt) {
            Class<?> result = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    Intrinsics.throwNpe();
                }
                result = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            return result;
        }

        @Override
        @JetMethod(returnType="?Ljava/io/InputStream;")
        public InputStream loadResource(@JetValueParameter(name="name", type="?Ljava/lang/String;") String name) {
            Thread thread = Thread.currentThread();
            if (thread == null) {
                Intrinsics.throwNpe();
            }
            ClassLoader classLoader = thread.getContextClassLoader();
            if (classLoader == null) {
                Intrinsics.throwNpe();
            }
            InputStream isS = classLoader.getResourceAsStream(name);
            boolean bl = true;
            if (isS == null) {
                bl = false;
            }
            if (bl) {
                return isS;
            }
            return null;
        }

        @JetConstructor
        public ThreadContextLoader() {
            this.order = 4;
        }
    }

    @JetClass(signature="Lorg/kevoree/kcl/internal/ProxyClassLoader;", flags=16, abiVersion=6)
    public final class SystemLoader
    extends ProxyClassLoader
    implements JetObject {
        @Override
        @JetMethod(returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
        public Class<? extends Object> loadClass(@JetValueParameter(name="className", type="?Ljava/lang/String;") String className, @JetValueParameter(name="resolveIt", type="Z") boolean resolveIt) {
            Class<? extends Object> result = null;
            try {
                result = KevoreeJarClassLoader.this.callCLfindSystemClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            return result;
        }

        @Override
        @JetMethod(returnType="?Ljava/io/InputStream;")
        public InputStream loadResource(@JetValueParameter(name="name", type="?Ljava/lang/String;") String name) {
            Object isS = null;
            boolean bl = true;
            if (isS == null) {
                bl = false;
            }
            if (bl) {
                return isS;
            }
            return null;
        }

        @JetConstructor
        public SystemLoader() {
            this.order = 5;
        }
    }

    @JetClass(signature="Lorg/kevoree/kcl/internal/ProxyClassLoader;", flags=16, abiVersion=6)
    public final class ParentLoader
    extends ProxyClassLoader
    implements JetObject {
        @Override
        @JetMethod(returnType="?Ljava/lang/Class<+?Ljava/lang/Object;>;")
        public Class<? extends Object> loadClass(@JetValueParameter(name="className", type="?Ljava/lang/String;") String className, @JetValueParameter(name="resolveIt", type="Z") boolean resolveIt) {
            Class<?> result = null;
            try {
                ClassLoader classLoader = KevoreeJarClassLoader.this.getParent();
                if (classLoader == null) {
                    Intrinsics.throwNpe();
                }
                result = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            return result;
        }

        @Override
        @JetMethod(returnType="?Ljava/io/InputStream;")
        public InputStream loadResource(@JetValueParameter(name="name", type="?Ljava/lang/String;") String name) {
            ClassLoader classLoader = KevoreeJarClassLoader.this.getParent();
            if (classLoader == null) {
                Intrinsics.throwNpe();
            }
            InputStream isS = classLoader.getResourceAsStream(name);
            boolean bl = true;
            if (isS == null) {
                bl = false;
            }
            if (bl) {
                return isS;
            }
            return null;
        }

        @JetConstructor
        public ParentLoader() {
            this.order = 3;
        }
    }
}

