/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import de.uka.ilkd.key.util.removegenerics.AbstractGenericRemover;
import de.uka.ilkd.key.util.removegenerics.GenericResolutionTransformation;
import de.uka.ilkd.key.util.removegenerics.monitor.GenericRemoverMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import recoder.java.CompilationUnit;
import recoder.java.PackageSpecification;
import recoder.java.reference.PackageReference;

public class GenericRemover
extends AbstractGenericRemover {
    private File outDir = new File(".");

    public GenericRemover(GenericRemoverMonitor monitor) {
        super(monitor);
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    @Override
    protected void saveModifiedCompilationUnit(CompilationUnit cu, String filename) throws IOException {
        File targetdir;
        PackageSpecification packageSpecification = cu.getPackageSpecification();
        if (packageSpecification != null) {
            String pack = this.toString(packageSpecification.getPackageReference());
            String subdir = pack.replace('.', File.separatorChar);
            targetdir = new File(this.outDir, subdir);
        } else {
            targetdir = this.outDir;
        }
        File outFile = new File(targetdir, filename);
        targetdir.mkdirs();
        GenericResolutionTransformation.debugOut("output file", outFile);
        FileWriter w = new FileWriter(outFile, StandardCharsets.UTF_8);
        w.write(cu.toSource());
        ((Writer)w).close();
    }

    private String toString(PackageReference packageReference) {
        StringBuilder ret = new StringBuilder(packageReference.getIdentifier().getText());
        packageReference = packageReference.getPackageReference();
        while (packageReference != null) {
            do {
                ret.insert(0, packageReference.getIdentifier().getText() + ".");
            } while ((packageReference = packageReference.getPackageReference()) != null);
        }
        return ret.toString();
    }
}

