/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import de.uka.ilkd.key.util.removegenerics.GenericResolutionTransformation;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.StatementContainer;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.Assignment;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.operator.TypeCast;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.NameReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Return;
import recoder.kit.ProblemReport;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTList;
import recoder.service.SourceInfo;

public class ResolveMemberReference
extends GenericResolutionTransformation {
    private final NameReference reference;
    private TypeReference typeToReference;

    public ResolveMemberReference(NameReference reference, CrossReferenceServiceConfiguration sc) {
        super(sc);
        this.reference = reference;
    }

    public ProblemReport analyze() {
        Type declarationType;
        MethodReference methRef;
        ASTList typeArguments;
        this.setProblemReport((ProblemReport)IDENTITY);
        if (this.reference instanceof MethodReference && (typeArguments = (methRef = (MethodReference)this.reference).getTypeArguments()) != null && typeArguments.size() > 0) {
            this.setProblemReport((ProblemReport)EQUIVALENCE);
        }
        SourceInfo sourceInfo = this.getSourceInfo();
        ProgramFactory programFactory = this.getServiceConfiguration().getProgramFactory();
        Type kernelType = declarationType = this.getFormalType();
        while (kernelType instanceof ArrayType) {
            kernelType = ((ArrayType)kernelType).getBaseType();
        }
        NonTerminalProgramElement parent = this.reference.getASTParent();
        boolean isTypeParameter = kernelType instanceof TypeParameter;
        boolean isStatement = parent instanceof StatementContainer;
        boolean isLHS = ResolveMemberReference.isLHS((Reference)this.reference);
        if (isTypeParameter && !isStatement && !isLHS) {
            Type actualType = sourceInfo.getType((ProgramElement)this.reference);
            Type genericfreeType = this.targetType(actualType);
            Type genericFreeDeclarationType = this.targetType(declarationType);
            Type resolvedType = this.resolveType();
            ResolveMemberReference.debugOut("actualType", actualType.getFullName());
            ResolveMemberReference.debugOut("genericfreeType", genericfreeType.getFullName());
            ResolveMemberReference.debugOut("resolvedType", resolvedType.getFullName());
            ResolveMemberReference.debugOut("declarationType", declarationType.getFullName());
            ResolveMemberReference.debugOut("genericFreeDeclarationType", genericFreeDeclarationType.getFullName());
            ClassType javaLangObject = this.getNameInfo().getJavaLangObject();
            if (resolvedType != genericFreeDeclarationType && resolvedType != javaLangObject) {
                this.typeToReference = TypeKit.createTypeReference((ProgramFactory)programFactory, (Type)resolvedType);
                this.setProblemReport((ProblemReport)EQUIVALENCE);
            }
        }
        return this.getProblemReport();
    }

    private static boolean isLHS(Reference reference) {
        NonTerminalProgramElement parent = reference.getASTParent();
        if (parent instanceof Assignment) {
            Assignment ass = (Assignment)parent;
            return ass.getExpressionAt(0) == reference;
        }
        return false;
    }

    private Type getFormalType() {
        SourceInfo sourceInfo = this.getSourceInfo();
        Type formalType = null;
        if (this.reference instanceof MethodReference) {
            MethodReference methodReference = (MethodReference)this.reference;
            formalType = sourceInfo.getMethod(methodReference).getReturnType();
        } else if (this.reference instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)this.reference;
            formalType = sourceInfo.getField(fieldReference).getType();
        } else if (this.reference instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)this.reference;
            formalType = sourceInfo.getVariable(variableReference).getType();
        }
        return formalType;
    }

    private Type resolveType() {
        Assignment assignment;
        NonTerminalProgramElement parent = this.reference.getASTParent();
        if (parent instanceof MethodReference) {
            MethodReference methRef = (MethodReference)parent;
            Method meth = this.getSourceInfo().getMethod(methRef);
            int index = -1;
            ASTList args = methRef.getArguments();
            if (args != null) {
                index = args.indexOf((Object)this.reference);
            }
            if (index == -1) {
                ClassType classType = meth.getContainingClassType();
                return classType;
            }
            Type argType = (Type)meth.getSignature().get(index);
            return this.targetType(argType);
        }
        if (parent instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)parent;
            Field field = this.getSourceInfo().getField(fieldRef);
            ClassType classType = field.getContainingClassType();
            return classType;
        }
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getChildAt(1) == this.reference) {
            Expression lhs = (Expression)assignment.getArguments().get(0);
            Type lhsType = this.getSourceInfo().getType(lhs);
            return this.targetType(lhsType);
        }
        if (parent instanceof VariableSpecification) {
            VariableSpecification varSpec = (VariableSpecification)parent;
            VariableDeclaration decl = (VariableDeclaration)parent.getASTParent();
            Type varType = this.targetType(this.getSourceInfo().getType(decl.getTypeReference()));
            int dimensions = varSpec.getDimensions();
            if (dimensions > 0) {
                varType = this.getNameInfo().createArrayType(varType, dimensions);
            }
            return varType;
        }
        if (parent instanceof Return) {
            MethodDeclaration md = ResolveMemberReference.getEnclosingMethod(parent);
            return this.targetType(md.getReturnType());
        }
        return this.targetType(this.getSourceInfo().getType((ProgramElement)this.reference));
    }

    private static MethodDeclaration getEnclosingMethod(NonTerminalProgramElement pe) {
        while (!(pe instanceof MethodDeclaration)) {
            pe = pe.getASTParent();
        }
        return (MethodDeclaration)pe;
    }

    public void transform() {
        TypeCast cast;
        ProgramFactory programFactory;
        ParenthesizedExpression replaceWith;
        if (this.reference instanceof MethodReference) {
            MethodReference methRef = (MethodReference)this.reference;
            methRef.setTypeArguments(null);
        }
        if (this.typeToReference != null && (replaceWith = (programFactory = this.getServiceConfiguration().getProgramFactory()).createParenthesizedExpression((Expression)(cast = programFactory.createTypeCast((Expression)this.reference.deepClone(), this.typeToReference)))) != null) {
            this.replace((ProgramElement)this.reference, (ProgramElement)replaceWith);
        }
    }
}

