/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.util.removegenerics;

import recoder.convenience.TreeWalker;
import recoder.java.Comment;
import recoder.java.ProgramElement;
import recoder.java.SingleLineComment;
import recoder.java.SourceElement;
import recoder.list.generic.ASTList;

public class SingleLineCommentRepairer {
    public static void repairSingleLineComments(ProgramElement programElement) {
        TreeWalker tw = new TreeWalker(programElement);
        while (tw.next()) {
            ProgramElement pe = tw.getProgramElement();
            ASTList comments = pe.getComments();
            if (comments == null) continue;
            for (Comment comment : comments) {
                if (!(comment instanceof SingleLineComment) || !comment.isPrefixed()) continue;
                SourceElement first = pe.getFirstElement();
                SourceElement.Position relpos = first.getRelativePosition();
                if (relpos == null || relpos == SourceElement.Position.UNDEFINED) {
                    relpos = new SourceElement.Position(1, 0);
                } else if (relpos.getLine() < 1) {
                    relpos.setLine(1);
                }
                first.setRelativePosition(relpos);
            }
        }
    }
}

