/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.common.util.Time;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.util.SecurityActions;
import org.keycloak.saml.common.util.SystemPropertiesUtil;

public class XMLTimeUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final ThreadLocal<DatatypeFactory> DATATYPE_FACTORY = new ThreadLocal<DatatypeFactory>(){

        @Override
        protected DatatypeFactory initialValue() {
            try {
                return XMLTimeUtil.newDatatypeFactory();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static XMLGregorianCalendar add(XMLGregorianCalendar value, long millis) {
        if (value == null) {
            return null;
        }
        XMLGregorianCalendar newVal = (XMLGregorianCalendar)value.clone();
        if (millis == 0L) {
            return newVal;
        }
        Duration duration = DATATYPE_FACTORY.get().newDuration(millis);
        newVal.add(duration);
        return newVal;
    }

    public static XMLGregorianCalendar subtract(XMLGregorianCalendar value, long millis) {
        return XMLTimeUtil.add(value, -millis);
    }

    public static XMLGregorianCalendar getIssueInstant(String timezone) {
        TimeZone tz = TimeZone.getTimeZone(timezone);
        DatatypeFactory dtf = DATATYPE_FACTORY.get();
        GregorianCalendar gc = new GregorianCalendar(tz);
        XMLGregorianCalendar xgc = dtf.newXMLGregorianCalendar(gc);
        Long offsetMilis = TimeUnit.MILLISECONDS.convert(Time.getOffset(), TimeUnit.SECONDS);
        if (offsetMilis != 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug(XMLTimeUtil.class.getName() + " timeOffset: " + offsetMilis);
            }
            xgc.add(XMLTimeUtil.parseAsDuration(offsetMilis.toString()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(XMLTimeUtil.class.getName() + " issueInstant: " + xgc.toString());
        }
        return xgc;
    }

    public static XMLGregorianCalendar getIssueInstant() {
        return XMLTimeUtil.getIssueInstant(XMLTimeUtil.getCurrentTimeZoneID());
    }

    public static String getCurrentTimeZoneID() {
        String timezonePropertyValue = SecurityActions.getSystemProperty("picketlink.timezone", "GMT");
        TimeZone timezone = "TIMEZONE_DEFAULT".equals(timezonePropertyValue) ? TimeZone.getDefault() : TimeZone.getTimeZone(timezonePropertyValue);
        return timezone.getID();
    }

    public static long inMilis(int valueInMins) {
        return (long)valueInMins * 60L * 1000L;
    }

    public static boolean isValid(XMLGregorianCalendar now, XMLGregorianCalendar notbefore, XMLGregorianCalendar notOnOrAfter) {
        int val;
        if (notbefore != null && ((val = notbefore.compare(now)) == 2 || val == 1)) {
            return false;
        }
        return notOnOrAfter == null || (val = notOnOrAfter.compare(now)) == 1;
    }

    public static Duration parseAsDuration(String timeValue) {
        if (timeValue == null) {
            PicketLinkLoggerFactory.getLogger().nullArgumentError("duration time");
        }
        DatatypeFactory factory = DATATYPE_FACTORY.get();
        try {
            if (timeValue.startsWith("P")) {
                return factory.newDuration(timeValue);
            }
            return factory.newDuration(Long.valueOf(timeValue));
        }
        catch (Exception e) {
            throw logger.samlMetaDataFailedToCreateCacheDuration(timeValue);
        }
    }

    public static XMLGregorianCalendar parse(String timeString) {
        DatatypeFactory factory = DATATYPE_FACTORY.get();
        return factory.newXMLGregorianCalendar(timeString);
    }

    private static DatatypeFactory newDatatypeFactory() throws DatatypeConfigurationException {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = SecurityActions.getTCCL();
        try {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(XMLTimeUtil.class.getClassLoader());
            }
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            return datatypeFactory;
        }
        finally {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(prevTCCL);
            }
        }
    }
}

