/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.keycloak.adapters.cloned.AdapterHttpClientConfig;
import org.keycloak.adapters.saml.config.Key;

public class IDP
implements Serializable {
    private String entityID;
    private String signatureAlgorithm;
    private String signatureCanonicalizationMethod;
    private SingleSignOnService singleSignOnService;
    private SingleLogoutService singleLogoutService;
    private List<Key> keys;
    private AdapterHttpClientConfig httpClientConfig = new HttpClientConfig();
    private boolean signaturesRequired = false;
    private String metadataUrl;
    private Integer allowedClockSkew;
    private TimeUnit allowedClockSkewUnit;

    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    public SingleSignOnService getSingleSignOnService() {
        return this.singleSignOnService;
    }

    public void setSingleSignOnService(SingleSignOnService singleSignOnService) {
        this.singleSignOnService = singleSignOnService;
        if (singleSignOnService != null) {
            singleSignOnService.setSignaturesRequired(this.signaturesRequired);
        }
    }

    public SingleLogoutService getSingleLogoutService() {
        return this.singleLogoutService;
    }

    public void setSingleLogoutService(SingleLogoutService singleLogoutService) {
        this.singleLogoutService = singleLogoutService;
        if (singleLogoutService != null) {
            singleLogoutService.setSignaturesRequired(this.signaturesRequired);
        }
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    public void setKeys(List<Key> keys) {
        this.keys = keys;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getSignatureCanonicalizationMethod() {
        return this.signatureCanonicalizationMethod;
    }

    public void setSignatureCanonicalizationMethod(String signatureCanonicalizationMethod) {
        this.signatureCanonicalizationMethod = signatureCanonicalizationMethod;
    }

    public AdapterHttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public void setHttpClientConfig(AdapterHttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public boolean isSignaturesRequired() {
        return this.signaturesRequired;
    }

    public void setSignaturesRequired(boolean signaturesRequired) {
        this.signaturesRequired = signaturesRequired;
    }

    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public void setMetadataUrl(String metadataUrl) {
        this.metadataUrl = metadataUrl;
    }

    public Integer getAllowedClockSkew() {
        return this.allowedClockSkew;
    }

    public void setAllowedClockSkew(Integer allowedClockSkew) {
        this.allowedClockSkew = allowedClockSkew;
    }

    public TimeUnit getAllowedClockSkewUnit() {
        return this.allowedClockSkewUnit;
    }

    public void setAllowedClockSkewUnit(TimeUnit allowedClockSkewUnit) {
        this.allowedClockSkewUnit = allowedClockSkewUnit;
    }

    public static class HttpClientConfig
    implements AdapterHttpClientConfig {
        private String truststore;
        private String truststorePassword;
        private String clientKeystore;
        private String clientKeystorePassword;
        private boolean allowAnyHostname;
        private boolean disableTrustManager;
        private int connectionPoolSize;
        private String proxyUrl;

        @Override
        public String getTruststore() {
            return this.truststore;
        }

        public void setTruststore(String truststore) {
            this.truststore = truststore;
        }

        @Override
        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }

        @Override
        public String getClientKeystore() {
            return this.clientKeystore;
        }

        public void setClientKeystore(String clientKeystore) {
            this.clientKeystore = clientKeystore;
        }

        @Override
        public String getClientKeystorePassword() {
            return this.clientKeystorePassword;
        }

        public void setClientKeystorePassword(String clientKeystorePassword) {
            this.clientKeystorePassword = clientKeystorePassword;
        }

        @Override
        public boolean isAllowAnyHostname() {
            return this.allowAnyHostname;
        }

        public void setAllowAnyHostname(boolean allowAnyHostname) {
            this.allowAnyHostname = allowAnyHostname;
        }

        @Override
        public boolean isDisableTrustManager() {
            return this.disableTrustManager;
        }

        public void setDisableTrustManager(boolean disableTrustManager) {
            this.disableTrustManager = disableTrustManager;
        }

        @Override
        public int getConnectionPoolSize() {
            return this.connectionPoolSize;
        }

        public void setConnectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
        }

        @Override
        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public void setProxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
        }
    }

    public static class SingleLogoutService
    implements Serializable {
        private Boolean signRequest;
        private Boolean signResponse;
        private Boolean validateRequestSignature;
        private Boolean validateResponseSignature;
        private String requestBinding;
        private String responseBinding;
        private String postBindingUrl;
        private String redirectBindingUrl;
        private boolean signaturesRequired = false;

        public boolean isSignRequest() {
            return this.signRequest == null ? this.signaturesRequired : this.signRequest;
        }

        public void setSignRequest(Boolean signRequest) {
            this.signRequest = signRequest;
        }

        public boolean isSignResponse() {
            return this.signResponse == null ? this.signaturesRequired : this.signResponse;
        }

        public void setSignResponse(Boolean signResponse) {
            this.signResponse = signResponse;
        }

        public boolean isValidateRequestSignature() {
            return this.validateRequestSignature == null ? this.signaturesRequired : this.validateRequestSignature;
        }

        public void setValidateRequestSignature(Boolean validateRequestSignature) {
            this.validateRequestSignature = validateRequestSignature;
        }

        public boolean isValidateResponseSignature() {
            return this.validateResponseSignature == null ? this.signaturesRequired : this.validateResponseSignature;
        }

        public void setValidateResponseSignature(Boolean validateResponseSignature) {
            this.validateResponseSignature = validateResponseSignature;
        }

        public String getRequestBinding() {
            return this.requestBinding;
        }

        public void setRequestBinding(String requestBinding) {
            this.requestBinding = requestBinding;
        }

        public String getResponseBinding() {
            return this.responseBinding;
        }

        public void setResponseBinding(String responseBinding) {
            this.responseBinding = responseBinding;
        }

        public String getPostBindingUrl() {
            return this.postBindingUrl;
        }

        public void setPostBindingUrl(String postBindingUrl) {
            this.postBindingUrl = postBindingUrl;
        }

        public String getRedirectBindingUrl() {
            return this.redirectBindingUrl;
        }

        public void setRedirectBindingUrl(String redirectBindingUrl) {
            this.redirectBindingUrl = redirectBindingUrl;
        }

        private void setSignaturesRequired(boolean signaturesRequired) {
            this.signaturesRequired = signaturesRequired;
        }
    }

    public static class SingleSignOnService
    implements Serializable {
        private Boolean signRequest;
        private Boolean validateResponseSignature;
        private String requestBinding;
        private String responseBinding;
        private String bindingUrl;
        private String assertionConsumerServiceUrl;
        private Boolean validateAssertionSignature;
        private boolean signaturesRequired = false;

        public boolean isSignRequest() {
            return this.signRequest == null ? this.signaturesRequired : this.signRequest;
        }

        public void setSignRequest(Boolean signRequest) {
            this.signRequest = signRequest;
        }

        public boolean isValidateResponseSignature() {
            return this.validateResponseSignature == null ? this.signaturesRequired : this.validateResponseSignature;
        }

        public void setValidateResponseSignature(Boolean validateResponseSignature) {
            this.validateResponseSignature = validateResponseSignature;
        }

        public boolean isValidateAssertionSignature() {
            return this.validateAssertionSignature == null ? false : this.validateAssertionSignature;
        }

        public void setValidateAssertionSignature(Boolean validateAssertionSignature) {
            this.validateAssertionSignature = validateAssertionSignature;
        }

        public String getRequestBinding() {
            return this.requestBinding;
        }

        public void setRequestBinding(String requestBinding) {
            this.requestBinding = requestBinding;
        }

        public String getResponseBinding() {
            return this.responseBinding;
        }

        public void setResponseBinding(String responseBinding) {
            this.responseBinding = responseBinding;
        }

        public String getBindingUrl() {
            return this.bindingUrl;
        }

        public void setBindingUrl(String bindingUrl) {
            this.bindingUrl = bindingUrl;
        }

        public String getAssertionConsumerServiceUrl() {
            return this.assertionConsumerServiceUrl;
        }

        public void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
            this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        }

        private void setSignaturesRequired(boolean signaturesRequired) {
            this.signaturesRequired = signaturesRequired;
        }
    }
}

