/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PublicKey;
import org.bouncycastle.openssl.PEMWriter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.keycloak.common.util.PemUtils;

public class PublishedRealmRepresentation {
    protected String realm;
    @JsonProperty(value="public_key")
    protected String publicKeyPem;
    @JsonProperty(value="token-service")
    protected String tokenServiceUrl;
    @JsonProperty(value="account-service")
    protected String accountServiceUrl;
    @JsonProperty(value="admin-api")
    protected String adminApiUrl;
    @JsonProperty(value="tokens-not-before")
    protected int notBefore;
    @JsonIgnore
    protected volatile transient PublicKey publicKey;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.publicKeyPem = publicKeyPem;
        this.publicKey = null;
    }

    @JsonIgnore
    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        if (this.publicKeyPem != null) {
            try {
                this.publicKey = PemUtils.decodePublicKey((String)this.publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicKey;
    }

    @JsonIgnore
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)publicKey);
            pemWriter.flush();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.publicKeyPem = PemUtils.removeBeginEnd((String)s);
    }

    public String getTokenServiceUrl() {
        return this.tokenServiceUrl;
    }

    public void setTokenServiceUrl(String tokenServiceUrl) {
        this.tokenServiceUrl = tokenServiceUrl;
    }

    public String getAccountServiceUrl() {
        return this.accountServiceUrl;
    }

    public void setAccountServiceUrl(String accountServiceUrl) {
        this.accountServiceUrl = accountServiceUrl;
    }

    public String getAdminApiUrl() {
        return this.adminApiUrl;
    }

    public void setAdminApiUrl(String adminApiUrl) {
        this.adminApiUrl = adminApiUrl;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }
}

