/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.broker.twitter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.IdentityProvidersResource;
import org.keycloak.examples.broker.twitter.TwitterOAuthResponse;
import org.keycloak.examples.broker.twitter.TwitterShowUserServlet;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.conf.ConfigurationBuilder;

@WebServlet(urlPatterns={"/twitter/showUser"})
public class TwitterShowUserServlet
extends HttpServlet {
    private Keycloak keycloak;
    private String authServer;
    private String realmName;
    private IdentityProviderRepresentation identityProvider;

    public void init(ServletConfig config) throws ServletException {
        this.initKeycloakClient(config);
    }

    public void destroy() {
        this.keycloak.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TwitterOAuthResponse twitterOAuthResponse = this.getTwitterOAuthResponse(request);
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setDebugEnabled(true).setOAuthConsumerKey((String)this.identityProvider.getConfig().get("clientId")).setOAuthConsumerSecret((String)this.identityProvider.getConfig().get("clientSecret")).setOAuthAccessToken(twitterOAuthResponse.getToken()).setOAuthAccessTokenSecret(twitterOAuthResponse.getTokenSecret());
        TwitterFactory tf = new TwitterFactory(cb.build());
        Twitter twitter = tf.getInstance();
        try {
            User user = twitter.users().showUser(twitterOAuthResponse.getScreenName());
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.println(new ObjectMapper().writeValueAsString((Object)user));
            writer.flush();
        }
        catch (TwitterException e) {
            throw new RuntimeException("Could not load social profile.", e);
        }
    }

    private TwitterOAuthResponse getTwitterOAuthResponse(HttpServletRequest req) {
        1 authFilter = new /* Unavailable Anonymous Inner Class!! */;
        Client client = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)authFilter)).build();
        WebTarget target = client.target(this.getIdentityProviderTokenUrl());
        return (TwitterOAuthResponse)target.request().get().readEntity(TwitterOAuthResponse.class);
    }

    private String getIdentityProviderTokenUrl() {
        return this.authServer + "/realms/" + this.realmName + "/broker/" + this.identityProvider.getAlias() + "/token";
    }

    private void initKeycloakClient(ServletConfig config) {
        JsonNode keycloakConfig;
        ServletContext servletContext = config.getServletContext();
        try {
            keycloakConfig = new ObjectMapper().readTree(servletContext.getResourceAsStream("WEB-INF/keycloak.json"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse keycloak config.", e);
        }
        this.authServer = keycloakConfig.get("auth-server-url").asText();
        this.realmName = keycloakConfig.get("realm").asText();
        this.keycloak = Keycloak.getInstance((String)this.authServer, (String)this.realmName, (String)"admin", (String)"password", (String)"admin-client", (String)"password");
        IdentityProvidersResource providersResource = this.keycloak.realm(this.realmName).identityProviders();
        this.identityProvider = providersResource.get("twitter").toRepresentation();
    }
}

