/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.identifiers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.efesto.common.api.identifiers.LocalUri;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;

class ModelLocalUriIdTest {
    ModelLocalUriIdTest() {
    }

    @Test
    void getFirstLocalUriPathComponent() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        LocalUri.LocalUriPathComponent retrieved = ModelLocalUriId.getFirstLocalUriPathComponent((LocalUri)parsed);
        LocalUri expected = LocalUri.parse((String)"/example");
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void asModelLocalUriIdWithModelLocalUriId() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId retrieved = new ModelLocalUriId(parsed);
        ModelLocalUriId modelLocalUriId = retrieved.asModelLocalUriId();
        Assertions.assertThat((Object)modelLocalUriId).isEqualTo((Object)retrieved);
        Assertions.assertThat((modelLocalUriId == retrieved ? 1 : 0) != 0).isTrue();
    }

    @Test
    void asModelLocalUriIdWithExtendingModelLocalUriId() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        ExtendingModelLocalUriId retrieved = new ExtendingModelLocalUriId(parsed);
        ModelLocalUriId modelLocalUriId = retrieved.asModelLocalUriId();
        Assertions.assertThat((Object)modelLocalUriId).isEqualTo((Object)retrieved);
        Assertions.assertThat((modelLocalUriId == retrieved ? 1 : 0) != 0).isFalse();
    }

    @Test
    void model() {
        String path = "/example/some-id/instances/some-instance-id";
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId retrieved = new ModelLocalUriId(parsed);
        Assertions.assertThat((String)retrieved.model()).isEqualTo("example");
    }

    @ParameterizedTest
    @ValueSource(strings={"/example/some-id/instances/some-instance-id", "/example"})
    void basePath(String path) {
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId retrieved = new ModelLocalUriId(parsed);
        String expected = path.replace("/example", "");
        Assertions.assertThat((String)retrieved.basePath()).isEqualTo(expected);
    }

    @ParameterizedTest
    @ValueSource(strings={"/example/some-id/instances/some-instance-id", "/example"})
    void fullPath(String path) {
        LocalUri parsed = LocalUri.parse((String)path);
        ModelLocalUriId retrieved = new ModelLocalUriId(parsed);
        Assertions.assertThat((String)retrieved.fullPath()).isEqualTo(path);
    }

    private static class ExtendingModelLocalUriId
    extends ModelLocalUriId {
        private static final long serialVersionUID = 640021472211924827L;

        public ExtendingModelLocalUriId(LocalUri path) {
            super(path);
        }
    }
}

