/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.util.ArrayList;
import org.drools.core.audit.ThreadedWorkingMemoryFileLogger;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.core.audit.WorkingMemoryFileLogger;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.beans.Person;
import org.kie.spring.factorybeans.LoggerAdaptor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringLoggersTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void runBeforeClass() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/loggers.xml");
    }

    @AfterClass
    public static void runAfterClass() {
    }

    @Test
    public void testStatelessSessionRefConsoleLogger() throws Exception {
        StatelessKieSession session = (StatelessKieSession)context.getBean("loggerSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)session;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
    }

    @Test
    public void testStatefulKnowledgeConsoleLogger() throws Exception {
        KieSession statefulSession = (KieSession)context.getBean("ConsoleLogger-statefulSession");
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
    }

    @Test
    public void testStatefulKnowledgeFileLogger() throws Exception {
        KieSession statefulSession = (KieSession)context.getBean("FileLogger-statefulSession");
        Assert.assertNotNull((Object)statefulSession.getGlobals().get("persons"));
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
        LoggerAdaptor adaptor = (LoggerAdaptor)context.getBean("sf_fl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatefulKnowledgeThreadedFileLogger() throws Exception {
        KieSession statefulSession = (KieSession)context.getBean("ThreadedFileLogger-statefulSession");
        Assert.assertNotNull((Object)statefulSession.getGlobals().get("persons"));
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof ThreadedWorkingMemoryFileLogger));
        }
        LoggerAdaptor adaptor = (LoggerAdaptor)context.getBean("sf_tfl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessKnowledgeConsoleLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("ConsoleLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
    }

    @Test
    public void testStatelessKnowledgeFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("FileLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
        LoggerAdaptor adaptor = (LoggerAdaptor)context.getBean("ss_fl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessKnowledgeThreadedFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("ThreadedFileLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof ThreadedWorkingMemoryFileLogger));
        }
        LoggerAdaptor loggerAdaptor = (LoggerAdaptor)context.getBean("ss_tfl_logger");
        Assert.assertNotNull((Object)loggerAdaptor);
        Assert.assertNotNull((Object)loggerAdaptor.getRuntimeLogger());
        loggerAdaptor.close();
    }

    @Test
    public void testSessionLoggersFromGroupAndNested() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("k1");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        Assert.assertEquals((long)2L, (long)impl.getRuleRuntimeEventListeners().size());
        ArrayList list = new ArrayList();
        statelessKnowledgeSession.setGlobal("persons", list);
        Assert.assertNotNull((Object)statelessKnowledgeSession.getGlobals().get("persons"));
        statelessKnowledgeSession.execute((Object)new Person("Darth", "Cheddar", 50));
        LoggerAdaptor adaptor = (LoggerAdaptor)context.getBean("k1_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
        adaptor.close();
        adaptor = (LoggerAdaptor)context.getBean("k1_console_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessNoNameFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("FileLogger-statelessSession-noNameLogger");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
    }
}

