/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.AuditLogService;
import org.junit.After;
import org.junit.Before;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

public abstract class AbstractJbpmSpringParameterizedTest
extends AbstractJbpmSpringTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJbpmSpringParameterizedTest.class);
    protected String contextPath;
    protected Context<?> runtimeManagerContext;
    private EntityManager em;

    public AbstractJbpmSpringParameterizedTest(String contextPath, Context<?> runtimeManagerContext) {
        this.contextPath = contextPath;
        this.runtimeManagerContext = runtimeManagerContext;
    }

    @Before
    public void setUp() {
        LOG.info("Creating spring context - " + this.contextPath);
        this.context = new ClassPathXmlApplicationContext(this.contextPath);
        LOG.info("The spring context created.");
    }

    @After
    public void cleanUp() {
        if (this.em != null) {
            this.em.close();
            this.em = null;
        }
    }

    protected KieSession getKieSession() {
        return this.getEngine().getKieSession();
    }

    protected AuditLogService getLogService() {
        return (AuditLogService)this.context.getBean("logService", AuditLogService.class);
    }

    protected RuntimeEngine getEngine() {
        return this.getManager().getRuntimeEngine(this.runtimeManagerContext);
    }

    protected RuntimeManager getManager() {
        return (RuntimeManager)this.context.getBean("runtimeManager", RuntimeManager.class);
    }

    protected RuntimeManager getSecondManager() {
        return (RuntimeManager)this.context.getBean("runtimeManager2", RuntimeManager.class);
    }

    protected TaskService getTaskService() {
        return this.getEngine().getTaskService();
    }

    protected AbstractPlatformTransactionManager getTransactionManager() {
        return (AbstractPlatformTransactionManager)this.context.getBean("jbpmTxManager", AbstractPlatformTransactionManager.class);
    }

    protected EntityManager getEntityManager() {
        if (this.em != null) {
            return this.em;
        }
        if (this.context.containsBean("jbpmEM")) {
            return (EntityManager)this.context.getBean("jbpmEM", EntityManager.class);
        }
        this.em = ((EntityManagerFactory)this.context.getBean("jbpmEMF", EntityManagerFactory.class)).createEntityManager();
        return this.em;
    }
}

