/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.io.File;
import java.io.FilenameFilter;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.spring.jbpm.tools.IntegrationSpringBase;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractJbpmSpringTest
extends IntegrationSpringBase {
    protected static PoolingDataSource pds;
    protected ClassPathXmlApplicationContext context;

    @BeforeClass
    public static void generalSetup() {
        System.setProperty("java.naming.factory.initial", "org.jbpm.test.util.CloseSafeMemoryContextFactory");
        System.setProperty("org.osjava.sj.root", "target/test-classes/config");
        System.setProperty("org.osjava.jndi.delimiter", "/");
        System.setProperty("org.osjava.sj.jndi.shared", "true");
        pds = AbstractJbpmSpringTest.setupPoolingDataSource();
    }

    @Before
    public void setup() {
        AbstractJbpmSpringTest.cleanupSingletonSessionId();
    }

    @After
    public void cleanup() {
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
    }

    @AfterClass
    public static void generalCleanup() {
        if (pds != null) {
            pds.close();
        }
        System.clearProperty("java.naming.factory.initial");
    }

    protected static PoolingDataSource setupPoolingDataSource() {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName("jdbc/jbpm-ds");
        pds.setClassName("org.h2.jdbcx.JdbcDataSource");
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("password", "");
        pds.getDriverProperties().put("URL", "jdbc:h2:mem:jbpm-db;MVCC=true");
        pds.init();
        return pds;
    }

    protected static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }
}

