/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;

@RunWith(value=Parameterized.class)
public class PerProcessInstanceWithExternalTXSpringTest
extends AbstractJbpmSpringParameterizedTest {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/jta-emf/per-process-instance.xml", ProcessInstanceIdContext.get()}};
        return Arrays.asList(data);
    }

    public PerProcessInstanceWithExternalTXSpringTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test(timeout=100000000L)
    public void testCompleteTasksWithSeparateThread() throws Exception {
        final RuntimeManager manager = this.getManager();
        RuntimeEngine engine = this.getEngine();
        KieSession ksession = this.getKieSession();
        long ksessionId = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        manager.disposeRuntimeEngine(engine);
        engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        Assert.assertEquals((long)ksessionId, (long)ksession.getIdentifier());
        ProcessInstanceLog log = this.getLogService().findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user '" + "john" + "'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        manager.disposeRuntimeEngine(engine);
        final Long processInstanceId = processInstance.getId();
        final Long firstTaskId = ((TaskSummary)tasks.get(0)).getId();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                UserTransaction ut = null;
                try {
                    ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                    ut.begin();
                    RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                    engine.getKieSession();
                    TaskService taskService = engine.getTaskService();
                    taskService.start(firstTaskId.longValue(), "john");
                    taskService.complete(firstTaskId.longValue(), "john", null);
                    System.out.println("Task for john completed");
                    manager.disposeRuntimeEngine(engine);
                    ut.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        ut.rollback();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        t.start();
        t.join();
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user '" + "mary" + "'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        final Long secondTaskId = ((TaskSummary)tasks.get(0)).getId();
        t = new Thread(new Runnable(){

            @Override
            public void run() {
                UserTransaction ut = null;
                try {
                    ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                    ut.begin();
                    RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                    engine.getKieSession();
                    TaskService taskService = engine.getTaskService();
                    taskService.start(secondTaskId.longValue(), "mary");
                    taskService.complete(secondTaskId.longValue(), "mary", null);
                    System.out.println("Task for mary completed");
                    manager.disposeRuntimeEngine(engine);
                    ut.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        ut.rollback();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        t.start();
        t.join();
        try {
            engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = engine.getKieSession();
            processInstance = ksession.getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
            System.out.println("Process instance completed");
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
    }
}

