/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringScopeTest {
    private static final Logger log = LoggerFactory.getLogger(KieSpringScopeTest.class);
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/beans-with-scope.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testStatelessPrototypeKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("statelessPrototypeSession");
        Assert.assertNotNull((Object)ksession);
        StatelessKieSession anotherKsession = (StatelessKieSession)context.getBean("statelessPrototypeSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertNotEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @Test
    public void testStatelessSingletonKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("statelessSingletonSession");
        Assert.assertNotNull((Object)ksession);
        StatelessKieSession anotherKsession = (StatelessKieSession)context.getBean("statelessSingletonSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @Test
    public void testStatefulSingletonKieSession() throws Exception {
        KieSession ksession = (KieSession)context.getBean("statefulSingletonSession");
        Assert.assertNotNull((Object)ksession);
        KieSession anotherKsession = (KieSession)context.getBean("statefulSingletonSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @Test
    public void testStatefulPrototypeKieSession() throws Exception {
        KieSession ksession = (KieSession)context.getBean("statefulPrototypeSession");
        Assert.assertNotNull((Object)ksession);
        KieSession anotherKsession = (KieSession)context.getBean("statefulPrototypeSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertNotEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @Test
    public void testConcurrentlyGetStatefulPrototypeKieSession() throws Exception {
        int nThreads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        final ConcurrentHashMap ksessionMap = new ConcurrentHashMap();
        final CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    KieSession ksession = (KieSession)context.getBean("statefulPrototypeSession");
                    Object put = ksessionMap.put(ksession.getIdentifier(), new Object());
                    if (put != null) {
                        log.warn("ksession:{} repeated", (Object)ksession);
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
        Assert.assertEquals((long)10L, (long)ksessionMap.size());
    }

    @AfterClass
    public static void tearDown() {
    }
}

