/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.wb.selenium.model.KieWbDistribution;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.AdminPagePerspective;
import org.kie.wb.selenium.model.persps.AppsPerspective;
import org.kie.wb.selenium.model.persps.ArtifactRepositoryPerspective;
import org.kie.wb.selenium.model.persps.BusinessDashboardsPerspective;
import org.kie.wb.selenium.model.persps.ExecutionErrorsPerspective;
import org.kie.wb.selenium.model.persps.ExecutionServersPerspective;
import org.kie.wb.selenium.model.persps.HomePerspective;
import org.kie.wb.selenium.model.persps.JobsPerspective;
import org.kie.wb.selenium.model.persps.ProcessAndTaskDashboardPerspective;
import org.kie.wb.selenium.model.persps.ProcessDefinitionsPerspective;
import org.kie.wb.selenium.model.persps.ProcessInstancesPerspective;
import org.kie.wb.selenium.model.persps.ProjectLibraryPerspective;
import org.kie.wb.selenium.model.persps.ProvisioningManagementPerspective;
import org.kie.wb.selenium.model.persps.TaskAdministrationPerspective;
import org.kie.wb.selenium.model.persps.TasksPerspective;

public class Persp<T extends AbstractPerspective> {
    public static final Persp<HomePerspective> HOME = new Persp<HomePerspective>("N/A", "Home", HomePerspective.class);
    public static final Persp<AdminPagePerspective> ADMIN = new Persp<AdminPagePerspective>("N/A", "Admin", AdminPagePerspective.class);
    public static final Persp<ArtifactRepositoryPerspective> ARTIFACTS = new Persp<ArtifactRepositoryPerspective>("N/A", "Artifacts", ArtifactRepositoryPerspective.class);
    public static final Persp<ProjectLibraryPerspective> PROJECTS = new Persp<ProjectLibraryPerspective>("Design", "Projects", ProjectLibraryPerspective.class, KieWbDistribution.KIE_DROOLS_WB, KieWbDistribution.KIE_WB);
    public static final Persp<BusinessDashboardsPerspective> DASHBOARDS = new Persp<BusinessDashboardsPerspective>("Design", "Dashboards", BusinessDashboardsPerspective.class);
    public static final Persp<ProvisioningManagementPerspective> DEPLOYMENTS = new Persp<ProvisioningManagementPerspective>("DevOps", "Deployments", ProvisioningManagementPerspective.class);
    public static final Persp<ExecutionServersPerspective> EXECUTION_SERVERS = new Persp<ExecutionServersPerspective>("DevOps", "Execution Servers", ExecutionServersPerspective.class);
    public static final Persp<ProcessDefinitionsPerspective> PROCESS_DEFINITIONS = new Persp<ProcessDefinitionsPerspective>("Manage", "Process Definitions", ProcessDefinitionsPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    public static final Persp<ProcessInstancesPerspective> PROCESS_INSTANCES = new Persp<ProcessInstancesPerspective>("Manage", "Process Instances", ProcessInstancesPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    public static final Persp<TaskAdministrationPerspective> TASK_ADMINISTRATION = new Persp<TaskAdministrationPerspective>("Manage", "Tasks Administration", TaskAdministrationPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    public static final Persp<JobsPerspective> JOBS = new Persp<JobsPerspective>("Manage", "Jobs", JobsPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    public static final Persp<ExecutionErrorsPerspective> EXECUTION_ERRORS = new Persp<ExecutionErrorsPerspective>("Manage", "Execution Errors", ExecutionErrorsPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    public static final Persp<TasksPerspective> TASKS = new Persp<TasksPerspective>("Track", "Task Lists", TasksPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    public static final Persp<ProcessAndTaskDashboardPerspective> PROCESS_AND_TASK_DASHBOARD = new Persp<ProcessAndTaskDashboardPerspective>("Track", "Process & Task Reports", ProcessAndTaskDashboardPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    public static final Persp<AppsPerspective> BUSINESS_DASHBOARDS = new Persp<AppsPerspective>("Track", "Business Dashboards", AppsPerspective.class, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    private static final List<Persp<? extends AbstractPerspective>> ALL_PERSPECTIVES = Collections.unmodifiableList(Arrays.asList(ADMIN, HOME, PROJECTS, DASHBOARDS, DEPLOYMENTS, EXECUTION_SERVERS, PROCESS_DEFINITIONS, PROCESS_INSTANCES, TASK_ADMINISTRATION, JOBS, EXECUTION_ERRORS, TASKS, PROCESS_AND_TASK_DASHBOARD, BUSINESS_DASHBOARDS));
    private final String parentMenu;
    private final String menuItem;
    private final Class<T> perspPageObjectClass;
    private final List<KieWbDistribution> kieWbDistributions;

    private Persp(String parentMenu, String menuItem, Class<T> perspPageObjectClass) {
        this(parentMenu, menuItem, perspPageObjectClass, KieWbDistribution.KIE_DROOLS_WB, KieWbDistribution.KIE_WB, KieWbDistribution.KIE_WB_MONITORING);
    }

    private Persp(String parentMenu, String menuItem, Class<T> perspPageObjectClass, KieWbDistribution ... distributions) {
        this.parentMenu = parentMenu;
        this.menuItem = menuItem;
        this.perspPageObjectClass = perspPageObjectClass;
        this.kieWbDistributions = Arrays.asList(distributions);
    }

    public static List<Persp<? extends AbstractPerspective>> getAllPerspectives(KieWbDistribution distribution) {
        return ALL_PERSPECTIVES.stream().filter(perspective -> perspective.getKieWbDistributions().contains((Object)distribution)).collect(Collectors.toList());
    }

    public String getMenu() {
        return this.parentMenu;
    }

    public String getName() {
        return this.menuItem;
    }

    public Class<T> getPerspectivePageObjectClass() {
        return this.perspPageObjectClass;
    }

    public List<KieWbDistribution> getKieWbDistributions() {
        return this.kieWbDistributions;
    }

    public String toString() {
        return this.getName().replace(' ', '_');
    }
}

