/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps;

import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.authoring.ConflictingRepositoriesModal;
import org.kie.wb.selenium.model.persps.authoring.ImportExampleModal;
import org.kie.wb.selenium.util.Repository;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectLibraryPerspective
extends AbstractPerspective {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectLibraryPerspective.class);
    private static final By WELCOME_MESSAGE = By.id((String)"welcome");
    private static final By TEAM_BREADCRUMB = By.linkText((String)"myteam");
    private static final By IMPORT_PROJECT_BUTTON = By.id((String)"import-project-button");
    private static final By ADVANCED_IMPORT_BUTTON = By.linkText((String)"Advanced Import");
    private static final By BUILD_AND_DEPLOY_BUTTON = ByJQuery.selector((String)"button:contains('Build & Deploy')");

    @Override
    public void waitForLoaded() {
        this.isDisplayed();
    }

    @Override
    public boolean isDisplayed() {
        return Waits.isElementPresent(TEAM_BREADCRUMB, 60);
    }

    private ImportExampleModal importExample() {
        this.click(IMPORT_PROJECT_BUTTON);
        this.click(ADVANCED_IMPORT_BUTTON);
        return ImportExampleModal.newInstance();
    }

    public boolean isProjectListEmpty() {
        return Waits.isElementPresent(WELCOME_MESSAGE);
    }

    public void openProjectList() {
        this.click(TEAM_BREADCRUMB);
    }

    public void importDemoProject(String projectName) {
        this.click((By)ByJQuery.selector((String)("button:contains('" + projectName + "')")));
    }

    public void buildAndDeployProject() {
        this.click(BUILD_AND_DEPLOY_BUTTON);
        this.possiblyOverrideGavConflict();
    }

    public void importStockExampleProject(String targetRepo, String ... projects) {
        ImportExampleModal modal = this.importExample();
        modal.selectStockRepository();
        modal.selectProjects(projects);
        modal.setTargetRepo(targetRepo);
    }

    public void importCustomExampleProject(Repository repo, String targetRepo, String ... projects) {
        ImportExampleModal modal = this.importExample();
        modal.selectCustomRepository(repo.getUrl());
        modal.selectProjects(projects);
        modal.setTargetRepo(targetRepo);
    }

    private void possiblyOverrideGavConflict() {
        try {
            ConflictingRepositoriesModal modal = ConflictingRepositoriesModal.newInstance();
            modal.overrideArtifactInMavenRepo();
        }
        catch (NoSuchElementException | TimeoutException ignored) {
            LOG.info("Modal showing GAV conflict didn't appear");
        }
    }
}

