/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface CatchingRunnable
extends Runnable {
    @Override
    default public void run() {
        try {
            this.runSafely();
        }
        catch (Throwable e) {
            CatchingRunnable.getLogger().error("Error occurred calling runSafely", e);
            try {
                this.handleExceptionSafely(e);
            }
            catch (Throwable ex) {
                CatchingRunnable.getLogger().error("Error occurred calling handleExceptionSafely", ex);
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CatchingRunnable.class);
    }

    default public void handleExceptionSafely(Throwable throwable) {
    }

    public void runSafely();
}

