/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import com.google.common.math.DoubleMath;

public final class KiwiDoubles {
    public static final double DEFAULT_FUZZY_EQUALS_TOLERANCE = 1.0E-9;

    public static boolean isZero(double value) {
        return KiwiDoubles.areEqual(value, 0.0);
    }

    public static boolean isNotZero(double value) {
        return KiwiDoubles.areNotEqual(value, 0.0);
    }

    public static boolean isCloseToZero(double value) {
        return KiwiDoubles.isCloseToZero(value, 1.0E-9);
    }

    public static boolean isCloseToZero(double value, double tolerance) {
        return DoubleMath.fuzzyEquals((double)value, (double)0.0, (double)tolerance);
    }

    public static boolean areEqual(double value1, double value2) {
        return Double.compare(value1, value2) == 0;
    }

    public static boolean areNotEqual(double value1, double value2) {
        return !KiwiDoubles.areEqual(value1, value2);
    }

    public static boolean areClose(double value1, double value2) {
        return KiwiDoubles.areClose(value1, value2, 1.0E-9);
    }

    public static boolean areClose(double value1, double value2, double tolerance) {
        return DoubleMath.fuzzyEquals((double)value1, (double)value2, (double)tolerance);
    }

    private KiwiDoubles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

