/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import com.google.errorprone.annotations.Immutable;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiThrowables {
    public static final ThrowableInfo EMPTY_THROWABLE_INFO = ThrowableInfo.of(null);

    public static ThrowableInfo throwableInfoOfNonNull(Throwable throwable) {
        KiwiPreconditions.checkArgumentNotNull(throwable, "Cannot generate throwableInfoOf from a null object");
        return ThrowableInfo.of(throwable);
    }

    public static Optional<ThrowableInfo> throwableInfoOfNullable(Throwable throwable) {
        return Optional.ofNullable(throwable).map(KiwiThrowables::throwableInfoOfNonNull);
    }

    public static Optional<Throwable> nextCauseOf(Throwable throwable) {
        KiwiPreconditions.checkArgumentNotNull(throwable, "Cannot generate nextCauseOf from a null object");
        return Optional.ofNullable(throwable.getCause());
    }

    public static Optional<Throwable> nextCauseOfNullable(Throwable throwable) {
        return Optional.ofNullable(throwable).map(Throwable::getCause);
    }

    public static Optional<Throwable> rootCauseOf(Throwable throwable) {
        KiwiPreconditions.checkArgumentNotNull(throwable, "Cannot generate rootCauseOf from a null object");
        return Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)throwable));
    }

    public static Optional<Throwable> rootCauseOfNullable(Throwable throwable) {
        return Optional.ofNullable(throwable).map(ExceptionUtils::getRootCause);
    }

    public static String typeOf(Throwable throwable) {
        KiwiPreconditions.checkArgumentNotNull(throwable, "Cannot generate typeOf from a null object");
        return throwable.getClass().getName();
    }

    public static Optional<String> typeOfNullable(Throwable throwable) {
        return Optional.ofNullable(throwable).map(Object::getClass).map(Class::getName);
    }

    public static Optional<String> messageOf(Throwable throwable) {
        KiwiPreconditions.checkArgumentNotNull(throwable, "Cannot generate messageOf from a null object");
        return Optional.ofNullable(throwable.getMessage());
    }

    public static Optional<String> messageOfNullable(Throwable throwable) {
        return Optional.ofNullable(throwable).map(Throwable::getMessage);
    }

    public static String stackTraceOf(Throwable throwable) {
        KiwiPreconditions.checkArgumentNotNull(throwable, "Cannot generate stackTraceOf from a null object");
        return ExceptionUtils.getStackTrace((Throwable)throwable);
    }

    public static Optional<String> stackTraceOfNullable(Throwable throwable) {
        return Optional.ofNullable(throwable).map(ExceptionUtils::getStackTrace);
    }

    public static Throwable unwrap(Throwable throwable, Class<?> wrapperClass) {
        KiwiPreconditions.checkArgumentNotNull(throwable, "throwable cannot be null");
        KiwiPreconditions.checkArgumentNotNull(wrapperClass, "wrapperClass cannot be null");
        if (throwable.getClass().equals(wrapperClass)) {
            return throwable.getCause();
        }
        return throwable;
    }

    private KiwiThrowables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Immutable
    public static final class ThrowableInfo {
        public final String type;
        public final String message;
        public final String stackTrace;
        public final Throwable cause;

        public static ThrowableInfo of(Throwable throwable) {
            return new ThrowableInfo(KiwiThrowables.typeOfNullable(throwable).orElse(null), KiwiThrowables.messageOfNullable(throwable).orElse(null), KiwiThrowables.stackTraceOfNullable(throwable).orElse(null), KiwiThrowables.nextCauseOfNullable(throwable).orElse(null));
        }

        public boolean hasMessage() {
            return StringUtils.isNotBlank((CharSequence)this.message);
        }

        public Optional<String> getType() {
            return Optional.ofNullable(this.type);
        }

        public Optional<String> getMessage() {
            return Optional.ofNullable(this.message);
        }

        public Optional<String> getStackTrace() {
            return Optional.ofNullable(this.stackTrace);
        }

        public Optional<Throwable> getCause() {
            return Optional.ofNullable(this.cause);
        }

        @ConstructorProperties(value={"type", "message", "stackTrace", "cause"})
        private ThrowableInfo(String type, String message, String stackTrace, Throwable cause) {
            this.type = type;
            this.message = message;
            this.stackTrace = stackTrace;
            this.cause = cause;
        }
    }
}

