/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Versions {
    private static final Logger LOG = LoggerFactory.getLogger(Versions.class);

    public static String higherVersion(String left, String right) {
        return Versions.versionCompare(left, right) >= 0 ? left : right;
    }

    public static boolean isStrictlyHigherVersion(String left, String right) {
        return Versions.versionCompare(left, right) > 0;
    }

    public static boolean isHigherOrSameVersion(String left, String right) {
        return Versions.versionCompare(left, right) >= 0;
    }

    public static boolean isStrictlyLowerVersion(String left, String right) {
        return Versions.versionCompare(left, right) < 0;
    }

    public static boolean isLowerOrSameVersion(String left, String right) {
        return Versions.versionCompare(left, right) <= 0;
    }

    public static boolean isSameVersion(String left, String right) {
        return Versions.versionCompare(left, right) == 0;
    }

    public static int versionCompare(String left, String right) {
        int pos;
        KiwiPreconditions.checkArgumentNotBlank(left, "left version cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(right, "right version cannot be blank");
        if (left.equals(right)) {
            return 0;
        }
        String[] leftParts = left.split("[\\.-]");
        String[] rightParts = right.split("[\\.-]");
        for (pos = 0; pos < leftParts.length && pos < rightParts.length && leftParts[pos].equals(rightParts[pos]); ++pos) {
        }
        if (pos < leftParts.length && pos < rightParts.length) {
            return Versions.contextuallyCompare(leftParts[pos], rightParts[pos]);
        }
        return Integer.signum(leftParts.length - rightParts.length);
    }

    private static int contextuallyCompare(String leftPart, String rightPart) {
        if (StringUtils.isNumeric((CharSequence)leftPart) && StringUtils.isNumeric((CharSequence)rightPart)) {
            return Versions.compareNumeric(leftPart, rightPart);
        }
        return Versions.compareString(leftPart, rightPart);
    }

    private static int compareNumeric(String leftPart, String rightPart) {
        int diff = Integer.valueOf(leftPart).compareTo(Integer.valueOf(rightPart));
        return Integer.signum(diff);
    }

    private static int compareString(String leftPart, String rightPart) {
        int result = StringUtils.compare((String)leftPart.toLowerCase(), (String)rightPart.toLowerCase());
        return Integer.compare(result, 0);
    }

    private Versions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

