/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.concurrent;

import com.google.common.util.concurrent.Striped;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripedLock {
    private static final Logger LOG = LoggerFactory.getLogger(StripedLock.class);
    private static final String DEFAULT_KEY_WHEN_BLANK = "BLANK-LOCK-KEY";
    private static final int DEFAULT_NUM_STRIPES = Runtime.getRuntime().availableProcessors() * 4;
    private final Striped<ReadWriteLock> lock;

    public StripedLock() {
        this((Striped<ReadWriteLock>)Striped.readWriteLock((int)DEFAULT_NUM_STRIPES));
    }

    public StripedLock(int numStripes) {
        this((Striped<ReadWriteLock>)Striped.readWriteLock((int)numStripes));
    }

    public StripedLock(Striped<ReadWriteLock> lock) {
        this.lock = lock;
    }

    public void runWithReadLock(String lockKey, Runnable task) {
        this.supplyWithReadLock(lockKey, () -> {
            task.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T supplyWithReadLock(String lockKey, Supplier<T> task) {
        String nonNullKey = this.ensureNonBlankKey(lockKey);
        ReadWriteLock readWriteLock = (ReadWriteLock)this.lock.get((Object)nonNullKey);
        String lockHashCode = this.extractHashCode(readWriteLock);
        LOG.trace("Locking read lock {} for key {}", (Object)lockHashCode, (Object)nonNullKey);
        readWriteLock.readLock().lock();
        try {
            LOG.trace("Running task with read lock {} for key {}", (Object)lockHashCode, (Object)nonNullKey);
            T t = task.get();
            return t;
        }
        finally {
            LOG.trace("Unlocking read lock {} for key {}", (Object)lockHashCode, (Object)nonNullKey);
            readWriteLock.readLock().unlock();
        }
    }

    public void runWithWriteLock(String lockKey, Runnable task) {
        this.supplyWithWriteLock(lockKey, () -> {
            task.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T supplyWithWriteLock(String lockKey, Supplier<T> task) {
        String nonNullKey = this.ensureNonBlankKey(lockKey);
        ReadWriteLock readWriteLock = (ReadWriteLock)this.lock.get((Object)nonNullKey);
        String lockHashCode = this.extractHashCode(readWriteLock);
        LOG.trace("Locking write lock {} for key {}", (Object)lockHashCode, (Object)nonNullKey);
        readWriteLock.writeLock().lock();
        try {
            LOG.trace("Running task with write lock {} for key {}", (Object)lockHashCode, (Object)nonNullKey);
            T t = task.get();
            return t;
        }
        finally {
            LOG.trace("Unlocking write lock {} for key {}", (Object)lockHashCode, (Object)nonNullKey);
            readWriteLock.writeLock().unlock();
        }
    }

    private String ensureNonBlankKey(String key) {
        return StringUtils.isBlank((CharSequence)key) ? DEFAULT_KEY_WHEN_BLANK : key;
    }

    private String extractHashCode(Object obj) {
        return "@" + Integer.toHexString(System.identityHashCode(obj));
    }
}

