/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.jdbi2;

import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import org.kiwiproject.base.KiwiPreconditions;
import org.skife.jdbi.v2.DBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jdbi2Builders {
    private static final Logger LOG = LoggerFactory.getLogger(Jdbi2Builders.class);
    public static final String DEFAULT_HEALTH_CHECK_NAME = "database";
    private static final String NULL_ENVIRONMENT_MESSAGE = "Environment cannot be null";
    private static final String NULL_DATA_SOURCE_FACTORY_NAME = "PooledDataSourceFactory cannot be null";
    private static final String NULL_DATA_SOURCE_MESSAGE = "ManagedDataSource cannot be null";

    public static DBI buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory) {
        return Jdbi2Builders.buildManagedJdbi(environment, dataSourceFactory, DEFAULT_HEALTH_CHECK_NAME);
    }

    public static DBI buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, String healthCheckName) {
        KiwiPreconditions.checkArgumentNotNull(environment, NULL_ENVIRONMENT_MESSAGE);
        KiwiPreconditions.checkArgumentNotNull(dataSourceFactory, NULL_DATA_SOURCE_FACTORY_NAME);
        DBIFactory dbiFactory = new DBIFactory();
        DBI jdbi = dbiFactory.build(environment, dataSourceFactory, healthCheckName);
        LOG.debug("Created DBI instance: {}", (Object)jdbi);
        return jdbi;
    }

    public static DBI buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, ManagedDataSource dataSource) {
        return Jdbi2Builders.buildManagedJdbi(environment, dataSourceFactory, dataSource, DEFAULT_HEALTH_CHECK_NAME);
    }

    public static DBI buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, ManagedDataSource dataSource, String healthCheckName) {
        KiwiPreconditions.checkArgumentNotNull(environment, NULL_ENVIRONMENT_MESSAGE);
        KiwiPreconditions.checkArgumentNotNull(dataSourceFactory, NULL_DATA_SOURCE_FACTORY_NAME);
        KiwiPreconditions.checkArgumentNotNull(dataSource, NULL_DATA_SOURCE_MESSAGE);
        DBIFactory dbiFactory = new DBIFactory();
        DBI jdbi = dbiFactory.build(environment, dataSourceFactory, dataSource, healthCheckName);
        LOG.debug("Created DBI instance: {}", (Object)jdbi);
        return jdbi;
    }

    private Jdbi2Builders() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

