/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.jdbi3;

import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi3.JdbiFactory;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jdbi3Builders {
    private static final Logger LOG = LoggerFactory.getLogger(Jdbi3Builders.class);
    public static final String DEFAULT_HEALTH_CHECK_NAME = "database";
    private static final String NULL_ENVIRONMENT_MESSAGE = "Environment cannot be null";
    private static final String NULL_DATA_SOURCE_FACTORY_NAME = "PooledDataSourceFactory cannot be null";
    private static final String NULL_DATA_SOURCE_MESSAGE = "ManagedDataSource cannot be null";

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, JdbiPlugin ... jdbiPlugins) {
        return Jdbi3Builders.buildManagedJdbi(environment, dataSourceFactory, DEFAULT_HEALTH_CHECK_NAME, jdbiPlugins);
    }

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, String healthCheckName, JdbiPlugin ... jdbiPlugins) {
        KiwiPreconditions.checkArgumentNotNull(environment, NULL_ENVIRONMENT_MESSAGE);
        KiwiPreconditions.checkArgumentNotNull(dataSourceFactory, NULL_DATA_SOURCE_FACTORY_NAME);
        ManagedDataSource dataSource = dataSourceFactory.build(environment.metrics(), healthCheckName);
        return Jdbi3Builders.buildManagedJdbi(environment, dataSourceFactory, dataSource, healthCheckName, jdbiPlugins);
    }

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, ManagedDataSource dataSource, JdbiPlugin ... jdbiPlugins) {
        return Jdbi3Builders.buildManagedJdbi(environment, dataSourceFactory, dataSource, DEFAULT_HEALTH_CHECK_NAME, jdbiPlugins);
    }

    public static Jdbi buildManagedJdbi(Environment environment, PooledDataSourceFactory dataSourceFactory, ManagedDataSource dataSource, String healthCheckName, JdbiPlugin ... jdbiPlugins) {
        KiwiPreconditions.checkArgumentNotNull(environment, NULL_ENVIRONMENT_MESSAGE);
        KiwiPreconditions.checkArgumentNotNull(dataSourceFactory, NULL_DATA_SOURCE_FACTORY_NAME);
        KiwiPreconditions.checkArgumentNotNull(dataSource, NULL_DATA_SOURCE_MESSAGE);
        JdbiFactory factory = new JdbiFactory();
        Jdbi jdbi = factory.build(environment, dataSourceFactory, dataSource, healthCheckName);
        Jdbi3Builders.installPlugins(jdbi, jdbiPlugins);
        LOG.debug("Created JDBI v3 instance: {}", (Object)jdbi);
        return jdbi;
    }

    private static void installPlugins(Jdbi jdbi, JdbiPlugin ... jdbiPlugins) {
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        Arrays.stream(jdbiPlugins).filter(Predicate.not(Jdbi3Builders::isSqlObjectPlugin)).forEach(arg_0 -> ((Jdbi)jdbi).installPlugin(arg_0));
    }

    private static boolean isSqlObjectPlugin(JdbiPlugin jdbiPlugin) {
        return jdbiPlugin instanceof SqlObjectPlugin;
    }

    private Jdbi3Builders() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

