/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.metrics.health;

import com.codahale.metrics.health.HealthCheck;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.kiwiproject.io.TimeBasedDirectoryCleaner;

public class TimeBasedDirectoryCleanerHealthCheck
extends HealthCheck {
    public static final Duration DEFAULT_DELETE_ERROR_THRESHOLD = Duration.ofHours(1L);
    private static final boolean SUPPRESS_LEADING_ZERO_ELEMENTS = true;
    private static final boolean SUPPRESS_TRAILING_ZERO_ELEMENTS = true;
    private final TimeBasedDirectoryCleaner cleaner;
    private final long warningThresholdInMillis;
    private final String warningThresholdDescription;
    private final String intializedAt;

    public TimeBasedDirectoryCleanerHealthCheck(TimeBasedDirectoryCleaner cleaner) {
        this(cleaner, DEFAULT_DELETE_ERROR_THRESHOLD);
    }

    public TimeBasedDirectoryCleanerHealthCheck(TimeBasedDirectoryCleaner cleaner, Duration warningThreshold) {
        this.cleaner = cleaner;
        this.warningThresholdInMillis = warningThreshold.toMillis();
        this.warningThresholdDescription = DurationFormatUtils.formatDurationWords((long)this.warningThresholdInMillis, (boolean)true, (boolean)true);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm");
        this.intializedAt = ZonedDateTime.now().format(formatter);
    }

    protected HealthCheck.Result check() {
        long now = System.currentTimeMillis();
        long errorsWithinThreshold = this.cleaner.getRecentDeleteErrors().stream().filter(error -> this.errorHasOccurredWithinWarningThreshold(now, (TimeBasedDirectoryCleaner.DeleteError)error)).count();
        if (errorsWithinThreshold == 0L) {
            return HealthCheck.Result.healthy((String)"No delete errors in last %s (%d total errors since %s)", (Object[])new Object[]{this.warningThresholdDescription, this.cleaner.getDeleteErrorCount(), this.intializedAt});
        }
        return HealthCheck.Result.unhealthy((String)"%d delete error(s) in last %s (%d total errors since %s)", (Object[])new Object[]{errorsWithinThreshold, this.warningThresholdDescription, this.cleaner.getDeleteErrorCount(), this.intializedAt});
    }

    private boolean errorHasOccurredWithinWarningThreshold(long now, TimeBasedDirectoryCleaner.DeleteError error) {
        long ageInMillis = now - error.getTimestamp();
        return ageInMillis < this.warningThresholdInMillis;
    }
}

