/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Resources;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.kiwiproject.net.UncheckedURISyntaxException;

public final class KiwiPaths {
    public static Path pathFromResourceName(String resourceName) {
        try {
            return Paths.get(Resources.getResource((String)resourceName).toURI());
        }
        catch (URISyntaxException e) {
            throw KiwiPaths.newUncheckedException(resourceName, e);
        }
    }

    @VisibleForTesting
    static UncheckedURISyntaxException newUncheckedException(String resourceName, URISyntaxException e) {
        String message = "Cannot convert to URI: " + resourceName;
        return new UncheckedURISyntaxException(message, e);
    }

    private KiwiPaths() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

