/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.format.DataFormatDetector;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.json.JsonDetectionResult;
import org.kiwiproject.json.RuntimeJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHelper.class);
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("\\[(\\d+)]");
    private final ObjectMapper objectMapper;
    private final DataFormatDetector jsonFormatDetector;

    public JsonHelper() {
        this(JsonHelper.newDropwizardObjectMapper());
    }

    public JsonHelper(ObjectMapper objectMapper) {
        KiwiPreconditions.checkArgumentNotNull(objectMapper, "ObjectMapper cannot be null");
        this.objectMapper = objectMapper;
        this.jsonFormatDetector = new DataFormatDetector(new JsonFactory[]{objectMapper.getFactory()});
    }

    public static JsonHelper newDropwizardJsonHelper() {
        ObjectMapper mapper = JsonHelper.newDropwizardObjectMapper();
        return new JsonHelper(mapper);
    }

    public static ObjectMapper newDropwizardObjectMapper() {
        ObjectMapper mapper = Jackson.newObjectMapper();
        return JsonHelper.configureForMillisecondDateTimestamps(mapper);
    }

    public static ObjectMapper configureForMillisecondDateTimestamps(ObjectMapper mapper) {
        mapper.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        mapper.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        return mapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean isJson(@Nullable String content) {
        return this.isJson(content, StandardCharsets.UTF_8);
    }

    public boolean isJson(@Nullable String content, Charset charset) {
        return JsonHelper.detectJson(content, charset, this.jsonFormatDetector).isJson();
    }

    public JsonDetectionResult detectJson(@Nullable String content) {
        return this.detectJson(content, StandardCharsets.UTF_8);
    }

    public JsonDetectionResult detectJson(@Nullable String content, Charset charset) {
        return JsonHelper.detectJson(content, charset, this.jsonFormatDetector);
    }

    @VisibleForTesting
    static JsonDetectionResult detectJson(@Nullable String content, Charset charset, DataFormatDetector formatDetector) {
        try {
            boolean result = StringUtils.isNotBlank((CharSequence)content) && formatDetector.findFormat(content.getBytes(charset)).hasMatch();
            return new JsonDetectionResult(result, null);
        }
        catch (IOException ex) {
            LOG.warn("Unable to determine content format. Enable TRACE logging to see exception details. Exception type: {}. Exception message: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            LOG.trace("Exception details:", (Throwable)ex);
            return new JsonDetectionResult(null, ex);
        }
    }

    public String toJson(@Nullable Object object) {
        return this.toJson(object, OutputFormat.DEFAULT);
    }

    public String toJson(@Nullable Object object, OutputFormat format) {
        return this.toJson(object, format, null);
    }

    public String toJson(@Nullable Object object, OutputFormat format, @Nullable Class<?> jsonView) {
        KiwiPreconditions.checkArgumentNotNull(format, "format is required");
        if (Objects.isNull(object)) {
            return null;
        }
        if (object instanceof String && this.isJson((String)object)) {
            return (String)object;
        }
        ObjectWriter writer = this.objectMapper.writer();
        if (Objects.nonNull(jsonView)) {
            writer = writer.withView(jsonView);
        }
        if (format == OutputFormat.PRETTY) {
            writer = writer.withDefaultPrettyPrinter();
        }
        try {
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeJsonException(e);
        }
    }

    public String toJsonFromKeyValuePairs(Object ... kvPairs) {
        KiwiPreconditions.checkEvenItemCount(kvPairs, "must supply an even number of arguments");
        return this.toJson(KiwiMaps.newHashMap(kvPairs));
    }

    public String toJsonIgnoringPaths(@Nullable Object object, String ... ignoredPaths) {
        JsonNode root = this.getRootNode(this.toJson(object));
        Stream.of(ignoredPaths).forEach(path -> JsonHelper.removePathNode(root, path));
        return this.toJson(root);
    }

    public <T> T toObject(@Nullable String json, Class<T> targetClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, targetClass);
        }
        catch (MismatchedInputException e) {
            if (Objects.nonNull(e.getTargetType()) && KiwiLists.isNullOrEmpty(e.getPath()) && e.getTargetType().isAssignableFrom(String.class)) {
                return (T)json;
            }
            throw new RuntimeJsonException(e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeJsonException(e);
        }
    }

    public <T> T toObjectOrDefault(@Nullable String json, Class<T> clazz, T defaultValue) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return defaultValue;
        }
        return this.toObject(json, clazz);
    }

    public <T> T toObjectOrSupply(@Nullable String json, Class<T> clazz, Supplier<T> defaultValueSupplier) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return defaultValueSupplier.get();
        }
        return this.toObject(json, clazz);
    }

    public <T> T toObject(@Nullable String json, TypeReference<T> targetType) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, targetType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeJsonException(e);
        }
    }

    public <T> Optional<T> toObjectOptional(@Nullable String json, Class<T> targetClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return Optional.empty();
        }
        return Optional.of(this.toObject(json, targetClass));
    }

    public <T> List<T> toObjectList(@Nullable String json, TypeReference<List<T>> targetListType) {
        return this.toObject(json, targetListType);
    }

    public Map<String, Object> toMap(@Nullable String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (Map)this.objectMapper.readValue(json, MAP_TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeJsonException(e);
        }
    }

    public <K, V> Map<K, V> toMap(@Nullable String json, TypeReference<Map<K, V>> targetMapType) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (Map)this.objectMapper.readValue(json, targetMapType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeJsonException(e);
        }
    }

    public Map<String, String> toFlatMap(@Nullable Object object) {
        return this.toFlatMap(object, String.class);
    }

    public <T> Map<String, T> toFlatMap(@Nullable Object object, Class<T> valueClass) {
        if (Objects.isNull(object)) {
            return null;
        }
        List<String> paths = this.listObjectPaths(object);
        return paths.stream().filter(Objects::nonNull).collect(Collectors.toMap(path -> path, path -> this.getPath(object, (String)path, valueClass)));
    }

    public <T> T copy(T object) {
        if (Objects.isNull(object)) {
            return null;
        }
        return (T)this.copy(object, object.getClass());
    }

    public <T, R> R copy(T object, Class<R> targetClass) {
        return this.copyIgnoringPaths(object, targetClass, new String[0]);
    }

    public <T, R> R copyIgnoringPaths(T object, Class<R> targetClass, String ... ignoredPaths) {
        String json = this.toJsonIgnoringPaths(object, ignoredPaths);
        return this.toObject(json, targetClass);
    }

    public <T> T convert(Object fromObject, Class<T> targetType) {
        if (Objects.isNull(fromObject)) {
            return null;
        }
        if (targetType.isAssignableFrom(String.class)) {
            return (T)this.toJson(fromObject);
        }
        return (T)this.objectMapper.convertValue(fromObject, targetType);
    }

    public <T> T convert(Object fromObject, TypeReference<T> targetType) {
        if (Objects.isNull(fromObject)) {
            return null;
        }
        return (T)this.objectMapper.convertValue(fromObject, targetType);
    }

    public Map<String, Object> convertToMap(Object fromObject) {
        return this.convertToMap(fromObject, MAP_TYPE_REFERENCE);
    }

    public <K, V> Map<K, V> convertToMap(Object fromObject, TypeReference<Map<K, V>> targetMapType) {
        if (Objects.isNull(fromObject)) {
            return null;
        }
        return (Map)this.objectMapper.convertValue(fromObject, targetMapType);
    }

    public <T> T getPath(Object object, String path, Class<T> targetClass) {
        String json = this.toJson(object);
        return this.getPath(json, path, targetClass);
    }

    public <T> T getPath(String json, String path, Class<T> targetClass) {
        String pathNodeJson = this.getPathNode(json, path).toString();
        return this.toObject(pathNodeJson, targetClass);
    }

    public <T> T getPath(Object object, String path, TypeReference<T> targetType) {
        String json = this.toJson(object);
        return this.getPath(json, path, targetType);
    }

    public <T> T getPath(String json, String path, TypeReference<T> targetType) {
        String pathNodeJson = this.getPathNode(json, path).toString();
        return this.toObject(pathNodeJson, targetType);
    }

    private JsonNode getPathNode(String json, String path) {
        JsonNode rootNode = this.getRootNode(json);
        return (JsonNode)JsonHelper.getPathNode(rootNode, path).getRight();
    }

    public JsonNode removePath(@Nullable Object object, String path) {
        JsonNode rootNode = this.getRootNode(this.toJson(object));
        return JsonHelper.removePathNode(rootNode, path);
    }

    private static JsonNode removePathNode(JsonNode root, String path) {
        String[] parts = path.split("\\.");
        ContainerNode parentNode = (ContainerNode)JsonHelper.getPathNode(root, path).getLeft();
        if (Objects.nonNull(parentNode)) {
            String lastPart = parts[parts.length - 1];
            Matcher matcher = ARRAY_INDEX_PATTERN.matcher(lastPart);
            if (matcher.matches() && parentNode instanceof ArrayNode) {
                ((ArrayNode)parentNode).remove(Integer.parseInt(matcher.group(1)));
            } else if (parentNode instanceof ObjectNode) {
                ((ObjectNode)parentNode).remove(lastPart);
            } else {
                throw new IllegalArgumentException(KiwiStrings.f("Unable to remove element: {} from node: {}", lastPart, root));
            }
        }
        return root;
    }

    public <T> T updatePath(@Nullable Object object, String path, Object value, Class<T> targetClass) {
        JsonNode rootNode = this.getRootNode(this.toJson(object));
        JsonNode jsonNode = this.convert(value, JsonNode.class);
        JsonNode updatedNode = JsonHelper.updatePathNode(rootNode, path, jsonNode);
        return this.convert((Object)updatedNode, targetClass);
    }

    private static JsonNode updatePathNode(JsonNode root, String path, JsonNode value) {
        String[] parts = path.split("\\.");
        ContainerNode parentNode = (ContainerNode)JsonHelper.getPathNode(root, path).getLeft();
        if (Objects.nonNull(parentNode)) {
            String lastPart = parts[parts.length - 1];
            Matcher matcher = ARRAY_INDEX_PATTERN.matcher(lastPart);
            if (matcher.matches() && parentNode instanceof ArrayNode) {
                ((ArrayNode)parentNode).insert(Integer.parseInt(matcher.group(1)), value);
            } else if (parentNode instanceof ObjectNode) {
                ((ObjectNode)parentNode).replace(lastPart, value);
            } else {
                throw new IllegalArgumentException(KiwiStrings.f("Unable to set element: {} into parent root: {}", lastPart, root));
            }
        }
        return root;
    }

    private static Pair<ContainerNode<?>, JsonNode> getPathNode(JsonNode root, String path) {
        ContainerNode parent = null;
        String[] parts = path.split("\\.");
        JsonNode node = root;
        for (String pathPart : parts) {
            parent = node instanceof ContainerNode ? (ContainerNode)node : null;
            Matcher matcher = ARRAY_INDEX_PATTERN.matcher(pathPart);
            node = matcher.matches() ? node.path(Integer.parseInt(matcher.group(1))) : node.path(pathPart);
        }
        return Pair.of(parent, (Object)node);
    }

    public Map<String, List<String>> jsonDiff(@Nullable Object object1, @Nullable Object object2, String ... ignoredPaths) {
        return this.jsonDiff(Lists.newArrayList((Object[])new Object[]{object1, object2}), ignoredPaths);
    }

    public Map<String, List<String>> jsonDiff(@Nonnull List<Object> objectList, String ... ignoredPaths) {
        List<String> jsonList = KiwiPreconditions.requireNotNull(objectList).stream().map(obj -> this.toJsonIgnoringPaths(obj, ignoredPaths)).collect(Collectors.toList());
        return this.jsonDiff(jsonList);
    }

    public Map<String, List<String>> jsonDiff(@Nonnull List<String> listOfJson) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        KiwiPreconditions.requireNotNull(listOfJson).stream().map(this::listObjectPaths).flatMap(Collection::stream).forEach(path -> {
            List results = listOfJson.stream().map(json -> this.getPath((String)json, (String)path, (Class)String.class)).collect(Collectors.toList());
            if (KiwiLists.isNotNullOrEmpty(results)) {
                String match = (String)KiwiLists.first(results);
                if (!results.stream().allMatch(s -> StringUtils.equals((CharSequence)s, (CharSequence)match))) {
                    resultMap.put((String)path, new ArrayList(results));
                }
            }
        });
        return resultMap;
    }

    public boolean jsonEquals(Object ... objects) {
        List jsonNodeList = Stream.of(objects).map(this::toJson).map(this::getRootNode).collect(Collectors.toList());
        return jsonNodeList.stream().allMatch(jsonNode -> Objects.equals(jsonNode, KiwiLists.first(jsonNodeList)));
    }

    public boolean jsonEqualsIgnoringPaths(Object object1, Object object2, String ... ignoredPaths) {
        String json1 = this.toJsonIgnoringPaths(object1, ignoredPaths);
        String json2 = this.toJsonIgnoringPaths(object2, ignoredPaths);
        return this.jsonEquals(json1, json2);
    }

    public <T> boolean jsonPathsEqual(Object object1, Object object2, String path, Class<T> targetClass) {
        T value1 = this.getPath(object1, path, targetClass);
        T value2 = this.getPath(object2, path, targetClass);
        return Objects.equals(value1, value2);
    }

    public <T> T mergeObjects(T originalObject, Object updateObject, MergeOption ... mergeOptions) {
        String originalObjJson = this.toJson(originalObject);
        String updateObjJson = this.toJson(updateObject);
        JsonNode originalNode = this.getRootNode(originalObjJson);
        JsonNode updateNode = this.getRootNode(updateObjJson);
        JsonNode updatedNode = this.mergeNodes(originalNode, updateNode, mergeOptions);
        return (T)this.toObject(updatedNode.toString(), originalObject.getClass());
    }

    public JsonNode mergeNodes(JsonNode destinationNode, JsonNode updateNode, MergeOption ... mergeOptions) {
        boolean mergeArrays = ArrayUtils.contains((Object[])mergeOptions, (Object)((Object)MergeOption.MERGE_ARRAYS));
        boolean ignoreNulls = ArrayUtils.contains((Object[])mergeOptions, (Object)((Object)MergeOption.IGNORE_NULLS));
        return this.mergeNodes(destinationNode, updateNode, mergeArrays, ignoreNulls);
    }

    private JsonNode mergeNodes(JsonNode destinationNode, JsonNode updateNode, boolean mergeArrays, boolean ignoreNulls) {
        updateNode.fieldNames().forEachRemaining(fieldName -> {
            JsonNode node;
            JsonNode otherNode = updateNode.get(fieldName);
            if (Objects.nonNull(otherNode) && otherNode.isNull()) {
                if (ignoreNulls) {
                    return;
                }
                if (destinationNode instanceof ObjectNode) {
                    ((ObjectNode)destinationNode).putNull(fieldName);
                }
            }
            if (Objects.nonNull(node = destinationNode.get(fieldName)) && node.isContainerNode()) {
                if (node.isObject()) {
                    this.mergeNodes(node, otherNode, mergeArrays, ignoreNulls);
                } else if (node.isArray()) {
                    if (mergeArrays && otherNode.isArray()) {
                        otherNode.forEach(arg_0 -> ((ArrayNode)((ArrayNode)node)).add(arg_0));
                    } else {
                        ((ObjectNode)destinationNode).replace(fieldName, otherNode);
                    }
                }
            } else if (destinationNode instanceof ObjectNode) {
                ((ObjectNode)destinationNode).replace(fieldName, otherNode);
            } else {
                LOG.warn("Unhandled node {}: {}", fieldName, (Object)node);
            }
        });
        return destinationNode;
    }

    public List<String> listObjectPaths(@Nullable Object object) {
        JsonNode rootNode = this.getRootNode(this.toJson(object));
        return JsonHelper.listNodePaths(rootNode);
    }

    private JsonNode getRootNode(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return NullNode.getInstance();
        }
        try {
            return this.objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeJsonException(e);
        }
    }

    private static List<String> listNodePaths(JsonNode node) {
        ArrayList<String> paths = new ArrayList<String>();
        node.fieldNames().forEachRemaining(fieldName -> {
            JsonNode child = node.get(fieldName);
            if (Objects.nonNull(child)) {
                String parentPrefix = fieldName + ".";
                if (child.isObject()) {
                    JsonHelper.appendChildPaths(paths, child, parentPrefix);
                } else if (child.isArray()) {
                    JsonHelper.appendArrayNodePaths(paths, child, parentPrefix);
                } else {
                    paths.add((String)fieldName);
                }
            } else {
                LOG.warn("Unhandled node {}", fieldName);
            }
        });
        return paths;
    }

    private static void appendArrayNodePaths(List<String> paths, JsonNode child, String parentPrefix) {
        AtomicInteger index = new AtomicInteger();
        child.elements().forEachRemaining(arrayElement -> {
            int currentIndex = index.getAndIncrement();
            String currentPath = parentPrefix + KiwiStrings.f("[%s]", currentIndex);
            if (!arrayElement.isContainerNode()) {
                paths.add(currentPath);
            }
            JsonHelper.appendChildPaths(paths, arrayElement, currentPath + ".");
        });
    }

    private static void appendChildPaths(List<String> paths, JsonNode child, String parentPrefix) {
        List<String> childPaths = JsonHelper.listNodePaths(child);
        paths.addAll(childPaths.stream().map(path -> parentPrefix + path).collect(Collectors.toList()));
    }

    public static enum MergeOption {
        MERGE_ARRAYS,
        IGNORE_NULLS;

    }

    public static enum OutputFormat {
        DEFAULT,
        PRETTY;


        public static OutputFormat ofPrettyValue(String pretty) {
            return OutputFormat.ofPrettyValue(Boolean.parseBoolean(pretty));
        }

        public static OutputFormat ofPrettyValue(@Nullable Boolean pretty) {
            return Objects.nonNull(pretty) ? OutputFormat.ofPrettyValue((boolean)pretty) : DEFAULT;
        }

        public static OutputFormat ofPrettyValue(boolean pretty) {
            return pretty ? PRETTY : DEFAULT;
        }
    }
}

