/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.logging;

import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Supplier;

public final class LazyLogParameterSupplier {
    public static Supplier<Object> lazy(Supplier<Object> original) {
        return new ObjectSupplierWrapper(original);
    }

    private LazyLogParameterSupplier() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class ObjectSupplierWrapper
    implements Supplier<Object> {
        private final Supplier<Object> original;

        @Override
        public Object get() {
            return this.original.get();
        }

        public String toString() {
            Object value = this.get();
            return Objects.isNull(value) ? "null" : value.toString();
        }

        @ConstructorProperties(value={"original"})
        public ObjectSupplierWrapper(Supplier<Object> original) {
            this.original = original;
        }
    }
}

