/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.function.Supplier;
import org.kiwiproject.net.UncheckedMalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiInternetAddresses {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiInternetAddresses.class);
    @VisibleForTesting
    static InetAddressFinder addressFinder = new InetAddressFinder();

    public static Optional<SimpleHostInfo> getLocalHostInfo() {
        try {
            InetAddress address = addressFinder.getLocalHost();
            SimpleHostInfo hostInfo = SimpleHostInfo.fromInetAddress(address);
            return Optional.of(hostInfo);
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to get local host", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<InetAddress> getLocalHostInetAddress() {
        try {
            InetAddress address = addressFinder.getLocalHost();
            return Optional.of(address);
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to get local host", (Throwable)e);
            return Optional.empty();
        }
    }

    public static SimpleHostInfo getLocalHostInfo(SimpleHostInfo defaultValue) {
        return KiwiInternetAddresses.getLocalHostInfo().orElse(defaultValue);
    }

    public static InetAddress getLocalHostInetAddress(InetAddress defaultValue) {
        return KiwiInternetAddresses.getLocalHostInetAddress().orElse(defaultValue);
    }

    public static SimpleHostInfo getLocalHostInfo(Supplier<SimpleHostInfo> defaultValueSupplier) {
        return KiwiInternetAddresses.getLocalHostInfo().orElseGet(defaultValueSupplier);
    }

    public static InetAddress getLocalHostInetAddress(Supplier<InetAddress> defaultValueSupplier) {
        return KiwiInternetAddresses.getLocalHostInetAddress().orElseGet(defaultValueSupplier);
    }

    public static Optional<Integer> portFrom(String url) {
        try {
            return KiwiInternetAddresses.portFrom(new URL(Strings.nullToEmpty((String)url)));
        }
        catch (MalformedURLException e) {
            throw new UncheckedMalformedURLException(e);
        }
    }

    public static Optional<Integer> portFrom(URL url) {
        int port = url.getPort();
        return port == -1 ? Optional.empty() : Optional.of(port);
    }

    public static HostAndPort hostAndPortFrom(String url) {
        try {
            return KiwiInternetAddresses.hostAndPortFrom(new URL(Strings.nullToEmpty((String)url)));
        }
        catch (MalformedURLException e) {
            throw new UncheckedMalformedURLException(e);
        }
    }

    public static HostAndPort hostAndPortFrom(URL url) {
        if (url.getPort() == -1) {
            return HostAndPort.fromHost((String)url.getHost());
        }
        return HostAndPort.fromParts((String)url.getHost(), (int)url.getPort());
    }

    private KiwiInternetAddresses() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static void setAddressFinder(InetAddressFinder addressFinder) {
        KiwiInternetAddresses.addressFinder = addressFinder;
    }

    @VisibleForTesting
    static class InetAddressFinder {
        InetAddressFinder() {
        }

        InetAddress getLocalHost() throws UnknownHostException {
            return InetAddress.getLocalHost();
        }
    }

    public static class SimpleHostInfo {
        private final String hostName;
        private final String ipAddr;

        public static SimpleHostInfo fromInetAddress(InetAddress address) {
            return SimpleHostInfo.from(address.getHostName(), address.getHostAddress());
        }

        public static SimpleHostInfo from(String hostName, String ipAddr) {
            return SimpleHostInfo.builder().hostName(hostName).ipAddr(ipAddr).build();
        }

        @ConstructorProperties(value={"hostName", "ipAddr"})
        SimpleHostInfo(String hostName, String ipAddr) {
            this.hostName = hostName;
            this.ipAddr = ipAddr;
        }

        public static SimpleHostInfoBuilder builder() {
            return new SimpleHostInfoBuilder();
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleHostInfo)) {
                return false;
            }
            SimpleHostInfo other = (SimpleHostInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostName = this.getHostName();
            String other$hostName = other.getHostName();
            if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
                return false;
            }
            String this$ipAddr = this.getIpAddr();
            String other$ipAddr = other.getIpAddr();
            return !(this$ipAddr == null ? other$ipAddr != null : !this$ipAddr.equals(other$ipAddr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SimpleHostInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostName = this.getHostName();
            result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
            String $ipAddr = this.getIpAddr();
            result = result * 59 + ($ipAddr == null ? 43 : $ipAddr.hashCode());
            return result;
        }

        public String toString() {
            return "KiwiInternetAddresses.SimpleHostInfo(hostName=" + this.getHostName() + ", ipAddr=" + this.getIpAddr() + ")";
        }

        public static class SimpleHostInfoBuilder {
            private String hostName;
            private String ipAddr;

            SimpleHostInfoBuilder() {
            }

            public SimpleHostInfoBuilder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            public SimpleHostInfoBuilder ipAddr(String ipAddr) {
                this.ipAddr = ipAddr;
                return this;
            }

            public SimpleHostInfo build() {
                return new SimpleHostInfo(this.hostName, this.ipAddr);
            }

            public String toString() {
                return "KiwiInternetAddresses.SimpleHostInfo.SimpleHostInfoBuilder(hostName=" + this.hostName + ", ipAddr=" + this.ipAddr + ")";
            }
        }
    }
}

