/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.reflect.RuntimeReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiReflection {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiReflection.class);
    private static final Object[] ONE_NULL_ARG_OBJECT_ARRAY = new Object[]{null};
    private static final String UNDERSCORE = "_";

    public static Field findField(Object target, String fieldName) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeReflectionException(KiwiStrings.f("Cannot get field [%s] in object [%s]", fieldName, target), e);
        }
    }

    public static <T> T getTypedFieldValue(Object target, String fieldName, Class<T> type) {
        return type.cast(KiwiReflection.getFieldValue(target, fieldName));
    }

    public static Object getFieldValue(Object target, String fieldName) {
        Field field = KiwiReflection.findField(target, fieldName);
        return KiwiReflection.getFieldValue(target, field);
    }

    public static <T> T getTypedFieldValue(Object target, Field field, Class<T> type) {
        return type.cast(KiwiReflection.getFieldValue(target, field));
    }

    public static Object getFieldValue(Object target, Field field) {
        try {
            return field.get(target);
        }
        catch (Exception e) {
            throw new RuntimeReflectionException(KiwiStrings.f("Cannot get value of field [%s] in object [%s]", field.getName(), target), e);
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        Field field = KiwiReflection.findField(target, fieldName);
        KiwiReflection.setFieldValue(target, field, value);
    }

    public static void setFieldValue(Object target, Field field, Object value) {
        try {
            field.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeReflectionException(KiwiStrings.f("Error setting field [%s] on target [%s] with value [%s]", field.getName(), target, value), e);
        }
    }

    public static List<Field> nonStaticFieldsInHierarchy(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> currentType = type;
        while (Objects.nonNull(currentType)) {
            List nonStaticFields = Arrays.stream(currentType.getDeclaredFields()).filter(Predicate.not(KiwiReflection::isStatic)).collect(Collectors.toList());
            fields.addAll(nonStaticFields);
            currentType = currentType.getSuperclass();
        }
        return fields;
    }

    private static boolean isStatic(Field f) {
        return Modifier.isStatic(f.getModifiers());
    }

    public static List<Method> findPublicAccessorMethods(Object target) {
        Class<?> clazz = target.getClass();
        return KiwiReflection.findPublicAccessorMethods(clazz);
    }

    public static List<Method> findPublicAccessorMethods(Class<?> clazz) {
        return KiwiReflection.findPublicMethods(clazz, KiwiReflection::isPublicAccessorMethod);
    }

    public static boolean isPublicAccessorMethod(Method method) {
        return KiwiReflection.isNotGetClassMethod(method) && KiwiReflection.isGetOrIsAccessorMethod(method);
    }

    private static boolean isGetOrIsAccessorMethod(Method method) {
        return KiwiReflection.isStrictlyGetAccessorMethod(method) || KiwiReflection.isStrictlyIsAccessorMethod(method);
    }

    public static boolean isStrictlyGetAccessorMethod(Method method) {
        return KiwiReflection.isPublicMethodWithParameterCount(method, 0) && method.getName().startsWith("get") && KiwiReflection.isNotGetClassMethod(method) && !method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isNotGetClassMethod(Method method) {
        return !"getClass".equals(method.getName());
    }

    public static boolean isStrictlyIsAccessorMethod(Method method) {
        return KiwiReflection.isPublicMethodWithParameterCount(method, 0) && method.getName().startsWith("is") && method.getReturnType().equals(Boolean.TYPE);
    }

    public static List<Method> findPublicMutatorMethods(Object target) {
        Class<?> clazz = target.getClass();
        return KiwiReflection.findPublicMutatorMethods(clazz);
    }

    public static List<Method> findPublicMutatorMethods(Class<?> clazz) {
        return KiwiReflection.findPublicMethods(clazz, KiwiReflection::isPublicMutatorMethod);
    }

    public static List<Method> findPublicMethods(Class<?> clazz, Predicate<Method> predicate) {
        Method[] methods = clazz.getMethods();
        return Arrays.stream(methods).filter(predicate).collect(Collectors.toList());
    }

    public static boolean isPublicMutatorMethod(Method method) {
        return KiwiReflection.isPublicMethodWithParameterCount(method, 1) && method.getReturnType().equals(Void.TYPE) && method.getName().startsWith("set");
    }

    private static boolean isPublicMethodWithParameterCount(Method method, int desiredParameterCount) {
        return Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == desiredParameterCount;
    }

    public static void invokeMutatorMethodsWithNull(Object target) {
        KiwiReflection.findPublicMutatorMethods(target).stream().filter(KiwiReflection::acceptsOneReferenceType).forEach(mutator -> KiwiReflection.invokeVoidReturn(mutator, target, ONE_NULL_ARG_OBJECT_ARRAY));
    }

    private static boolean acceptsOneReferenceType(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && !parameterTypes[0].isPrimitive();
    }

    public static Optional<Method> findMethodOptionally(Class<?> targetClass, String methodName, Class<?> ... params) {
        return Optional.ofNullable(KiwiReflection.findMethodOrNull(targetClass, methodName, params));
    }

    public static Method findAccessor(Accessor methodType, String fieldName, Object target, Class<?> ... params) {
        return KiwiReflection.findAccessor(methodType, fieldName, KiwiPreconditions.requireNotNull(target).getClass(), params);
    }

    public static Method findAccessor(Accessor methodType, String fieldName, Class<?> targetClass, Class<?> ... params) {
        KiwiPreconditions.checkArgumentNotNull(methodType, "methodType cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(fieldName, "fieldName cannot be blank");
        KiwiPreconditions.checkArgumentNotNull(targetClass, "targetClass cannot be null");
        methodType.validateParameterCount(params);
        String strippedFieldName = StringUtils.remove((String)fieldName, (String)UNDERSCORE);
        String capitalizedFieldName = StringUtils.capitalize((String)strippedFieldName);
        String methodName = KiwiStrings.format(methodType.template, capitalizedFieldName);
        switch (methodType) {
            case GET: {
                return KiwiReflection.findGetOrIsMethod(targetClass, capitalizedFieldName, methodName);
            }
            case IS: {
                return KiwiReflection.findMethod(targetClass, methodName, new Class[0]);
            }
            case SET: {
                return KiwiReflection.findSetMethod(targetClass, methodName, params[0]);
            }
        }
        throw new IllegalStateException("Unaccounted for accessor type: " + methodType);
    }

    private static Method findGetOrIsMethod(Class<?> targetClass, String capitalizedFieldName, String methodName) {
        Method getMethod = KiwiReflection.findMethodOrNull(targetClass, methodName, new Class[0]);
        if (Objects.nonNull(getMethod)) {
            return getMethod;
        }
        String alternateMethodName = KiwiStrings.format(Accessor.IS.template, capitalizedFieldName);
        LOG.trace("Falling back to see if {} exists (the field is a primitive boolean)", (Object)alternateMethodName);
        return KiwiReflection.findMethod(targetClass, alternateMethodName, new Class[0]);
    }

    private static Method findSetMethod(Class<?> targetClass, String methodName, Class<?> param) {
        Method setMethod = KiwiReflection.findMethodOrNull(targetClass, methodName, param);
        if (Objects.nonNull(setMethod)) {
            return setMethod;
        }
        LOG.trace("Falling back to see if {} exists for a primitive value", (Object)methodName);
        Class primitiveParam = Primitives.unwrap(param);
        return KiwiReflection.findMethod(targetClass, methodName, primitiveParam);
    }

    @VisibleForTesting
    static Method findMethodOrNull(Class<?> targetClass, String methodName, Class<?> ... params) {
        try {
            return targetClass.getMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            LOG.trace("Did not find method named {} in {} with parameter types {}", new Object[]{methodName, targetClass, Arrays.toString(params), e});
            return null;
        }
        catch (Exception e) {
            LOG.warn("Error finding method named {} in {} with parameter types {}", new Object[]{methodName, targetClass, Arrays.toString(params), e});
            return null;
        }
    }

    public static Method findMethod(Class<?> targetClass, String methodName, Class<?> ... params) {
        try {
            return targetClass.getMethod(methodName, params);
        }
        catch (Exception e) {
            String error = KiwiStrings.f("Error finding method [%s] in [%s] with params %s", methodName, targetClass, Arrays.toString(params));
            throw new RuntimeReflectionException(error, e);
        }
    }

    public static <T> T invokeExpectingReturn(Method method, Object target, Class<T> returnType, Object ... args) {
        return returnType.cast(KiwiReflection.invokeExpectingReturn(method, target, args));
    }

    public static Object invokeExpectingReturn(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new RuntimeReflectionException(KiwiStrings.f("Error invoking method [%s] on target [%s] with args %s", method.getName(), target, Arrays.toString(args)), e);
        }
    }

    public static void invokeVoidReturn(Method method, Object target, Object ... args) {
        try {
            method.invoke(target, args);
        }
        catch (Exception e) {
            throw new RuntimeReflectionException(KiwiStrings.f("Error invoking void method [%s] on target [%s] with args %s", method.getName(), target, Arrays.toString(args)), e);
        }
    }

    private KiwiReflection() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Accessor {
        SET("set{}", "setter", 1),
        GET("get{}", "getter", 0),
        IS("is{}", "boolean getter", 0);

        private final String template;
        private final String description;
        private final int requiredArgs;

        private Accessor(String template, String description, int requiredArgs) {
            this.template = template;
            this.description = description;
            this.requiredArgs = requiredArgs;
        }

        void validateParameterCount(Class<?> ... parameterTypes) {
            KiwiPreconditions.checkArgumentNotNull(parameterTypes, "parameterTypes cannot be null");
            Preconditions.checkArgument((parameterTypes.length == this.requiredArgs ? 1 : 0) != 0, (String)"%s methods must have %s arguments", (Object)this.description, (int)this.requiredArgs);
        }
    }
}

