/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.event.Level;

final class RetryLogger {
    static void logAttempt(Logger logger, Level level, long currentAttempt, String message, Object ... args) {
        Preconditions.checkArgument((currentAttempt > 0L ? 1 : 0) != 0, (String)"currentAttempt must be a positive integer");
        if (currentAttempt == 1L) {
            logger.trace(message, args);
            return;
        }
        RetryLogger.logAttempt(logger, level, message, args);
    }

    static void logAttempt(Logger logger, Level level, String message, Object ... args) {
        switch (level) {
            case DEBUG: {
                logger.debug(message, args);
                break;
            }
            case INFO: {
                logger.info(message, args);
                break;
            }
            case WARN: {
                logger.warn(message, args);
                break;
            }
            case ERROR: {
                logger.error(message, args);
                break;
            }
            default: {
                logger.trace(message, args);
            }
        }
    }

    private RetryLogger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

