/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.security.KeyStoreType;
import org.kiwiproject.security.SSLContextException;
import org.kiwiproject.security.SSLContextProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(KiwiSecurity.class);
    private static final String ERROR_CREATING_SSL_CONTEXT = "Error creating SSLContext";
    private static final String ALGORITHM_NAME_CANNOT_BE_BLANK = "algorithm cannot be blank";

    public static SSLContext createSslContext(@Nullable String keyStorePath, @Nullable String keyStorePassword, String trustStorePath, String trustStorePassword, SSLContextProtocol protocol) {
        KiwiPreconditions.checkArgumentNotNull(protocol, "protocol cannot be null");
        return KiwiSecurity.createSslContext(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword, protocol.value);
    }

    public static SSLContext createSslContext(@Nullable String keyStorePath, @Nullable String keyStorePassword, String trustStorePath, String trustStorePassword, String protocol) {
        return KiwiSecurity.createSslContext(keyStorePath, keyStorePassword, KeyStoreType.JKS.value, trustStorePath, trustStorePassword, KeyStoreType.JKS.value, protocol);
    }

    public static SSLContext createSslContext(@Nullable String keyStorePath, @Nullable String keyStorePassword, String keyStoreType, String trustStorePath, String trustStorePassword, String trustStoreType, SSLContextProtocol protocol) {
        KiwiPreconditions.checkArgumentNotNull(protocol, "protocol cannot be null");
        return KiwiSecurity.createSslContext(keyStorePath, keyStorePassword, keyStoreType, trustStorePath, trustStorePassword, trustStoreType, protocol.value);
    }

    public static SSLContext createSslContext(@Nullable String keyStorePath, @Nullable String keyStorePassword, String keyStoreType, String trustStorePath, String trustStorePassword, String trustStoreType, String protocol) {
        return KiwiSecurity.createSslContext(keyStorePath, keyStorePassword, keyStoreType, KeyManagerFactory.getDefaultAlgorithm(), trustStorePath, trustStorePassword, trustStoreType, TrustManagerFactory.getDefaultAlgorithm(), protocol);
    }

    public static SSLContext createSslContext(@Nullable String keyStorePath, @Nullable String keyStorePassword, @Nullable String keyStoreType, @Nullable String keyManagerAlgorithm, String trustStorePath, String trustStorePassword, String trustStoreType, String trustManagerAlgorithm, String protocol) {
        if (StringUtils.isNotBlank((CharSequence)keyStorePath)) {
            KiwiPreconditions.checkArgumentNotNull(keyStorePassword, "keyStorePassword cannot be null");
            KiwiPreconditions.checkArgumentNotBlank(keyStoreType, "keyStoreType cannot be blank");
            KiwiPreconditions.checkArgumentNotBlank(keyManagerAlgorithm, "keyManagerAlgorithm cannot be blank");
        }
        KiwiPreconditions.checkArgumentNotBlank(trustStorePath, "trustStorePath cannot be blank");
        KiwiPreconditions.checkArgumentNotNull(trustStorePassword, "trustStorePassword cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(trustStoreType, "trustStoreType cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(trustManagerAlgorithm, "trustManagerAlgorithm cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(protocol, "protocol cannot be blank");
        try {
            Optional<KeyStore> optionalKeyStore = KiwiSecurity.getKeyStore(keyStoreType, keyStorePath, keyStorePassword);
            KeyManager[] keyManagers = optionalKeyStore.map(store -> KiwiSecurity.getKeyManagers(store, keyStorePassword, keyManagerAlgorithm)).orElse(null);
            KeyStore trustStore = KiwiSecurity.getKeyStore(trustStoreType, trustStorePath, trustStorePassword).orElseThrow(IllegalArgumentException::new);
            TrustManager[] trustManagers = KiwiSecurity.getTrustManagers(trustStore, trustManagerAlgorithm);
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            LOG.error(ERROR_CREATING_SSL_CONTEXT, (Throwable)e);
            Throwable cause = KiwiSecurity.unwrapNestedSslContextExceptionOrTake(e);
            throw new SSLContextException(ERROR_CREATING_SSL_CONTEXT, cause);
        }
    }

    private static Throwable unwrapNestedSslContextExceptionOrTake(Exception ex) {
        if (ex instanceof SSLContextException) {
            LOG.trace("Unwrapping nested SSLContextException");
            return ex.getCause();
        }
        return ex;
    }

    public static Optional<KeyStore> getKeyStore(KeyStoreType keyStoreType, String path, String password) {
        KiwiPreconditions.checkArgumentNotNull(keyStoreType, "keyStoreType cannot be null");
        return KiwiSecurity.getKeyStore(keyStoreType.value, path, password);
    }

    public static Optional<KeyStore> getKeyStore(String keyStoreType, String path, String password) {
        LOG.trace("Creating {} KeyStore/TrustStore for {}", (Object)keyStoreType, (Object)path);
        if (Objects.isNull(path) && Objects.isNull(password)) {
            LOG.debug("No keystore specified");
            return Optional.empty();
        }
        KiwiPreconditions.checkArgumentNotBlank(keyStoreType, "keyStoreType cannot be blank");
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            URL keyStoreUrl = Paths.get(path, new String[0]).toUri().toURL();
            try (InputStream inputStream = keyStoreUrl.openStream();){
                keyStore.load(inputStream, password.toCharArray());
            }
            return Optional.of(keyStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SSLContextException("Error getting key store", e);
        }
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, String keyStorePassword) {
        return KiwiSecurity.getKeyManagers(keyStore, keyStorePassword, KeyManagerFactory.getDefaultAlgorithm());
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, String keyStorePassword, String algorithm) {
        KiwiPreconditions.checkArgumentNotNull(keyStore, "keyStore cannot be null");
        KiwiPreconditions.checkArgumentNotNull(keyStorePassword, "keyStorePassword cannot be null (but can be blank)");
        KiwiPreconditions.checkArgumentNotBlank(algorithm, ALGORITHM_NAME_CANNOT_BE_BLANK);
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new SSLContextException("Error getting key managers", e);
        }
    }

    public static TrustManager[] getTrustManagers(KeyStore trustStore) {
        return KiwiSecurity.getTrustManagers(trustStore, TrustManagerFactory.getDefaultAlgorithm());
    }

    public static TrustManager[] getTrustManagers(KeyStore trustStore, String algorithm) {
        KiwiPreconditions.checkArgumentNotNull(trustStore, "trustStore cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(algorithm, ALGORITHM_NAME_CANNOT_BE_BLANK);
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new SSLContextException("Error getting trust managers", e);
        }
    }

    private KiwiSecurity() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

