/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.stream;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class KiwiMultimapCollectors {
    public static <K, V, A extends Multimap<K, V>> Collector<Map.Entry<K, V>, A, A> toMultimap(Supplier<A> supplier) {
        return Collector.of(supplier, (accumulator, entry) -> accumulator.put(entry.getKey(), entry.getValue()), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);
    }

    public static <K, V> Collector<Map.Entry<K, V>, Multimap<K, V>, Multimap<K, V>> toArrayListMultimap() {
        return KiwiMultimapCollectors.toMultimap(ArrayListMultimap::create);
    }

    public static <K, V> Collector<Map.Entry<K, V>, Multimap<K, V>, Multimap<K, V>> toHashMultimap() {
        return KiwiMultimapCollectors.toMultimap(HashMultimap::create);
    }

    public static <K, V> Collector<Map.Entry<K, V>, Multimap<K, V>, Multimap<K, V>> toLinkedHashMultimap() {
        return KiwiMultimapCollectors.toMultimap(LinkedHashMultimap::create);
    }

    private KiwiMultimapCollectors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

