/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.time;

import java.time.Instant;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public final class KiwiInstants {
    public static int getSecond(Instant instant) {
        return KiwiInstants.toZonedDateTime(instant).getSecond();
    }

    public static int getMinute(Instant instant) {
        return KiwiInstants.toZonedDateTime(instant).getMinute();
    }

    public static int getHour(Instant instant) {
        return KiwiInstants.toZonedDateTime(instant).getHour();
    }

    public static int getDayOfMonth(Instant instant) {
        return KiwiInstants.toZonedDateTime(instant).getDayOfMonth();
    }

    public static Month getMonth(Instant instant) {
        return KiwiInstants.toZonedDateTime(instant).getMonth();
    }

    public static int getMonthValue(Instant instant) {
        return KiwiInstants.getMonth(instant).getValue();
    }

    public static int getYear(Instant instant) {
        return KiwiInstants.toZonedDateTime(instant).getYear();
    }

    public static Instant minusMinutes(Instant instant, long minutes) {
        return KiwiInstants.minus(instant, minutes, ChronoUnit.MINUTES);
    }

    public static Instant minusHours(Instant instant, long hours) {
        return KiwiInstants.minus(instant, hours, ChronoUnit.HOURS);
    }

    public static Instant minusDays(Instant instant, long days) {
        return KiwiInstants.minus(instant, days, ChronoUnit.DAYS);
    }

    private static Instant minus(Instant instant, long value, TemporalUnit unit) {
        return instant.minus(value, unit);
    }

    public static Instant minusMonths(Instant instant, long months) {
        return KiwiInstants.minusUsingZDT(instant, months, ChronoUnit.MONTHS);
    }

    public static Instant minusYears(Instant instant, long years) {
        return KiwiInstants.minusUsingZDT(instant, years, ChronoUnit.YEARS);
    }

    public static Instant minusUsingZDT(Instant instant, long amountToSubtract, TemporalUnit unit) {
        return KiwiInstants.toZonedDateTime(instant).minus(amountToSubtract, unit).toInstant();
    }

    public static Instant plusMinutes(Instant instant, long minutes) {
        return KiwiInstants.plus(instant, minutes, ChronoUnit.MINUTES);
    }

    public static Instant plusHours(Instant instant, long hours) {
        return KiwiInstants.plus(instant, hours, ChronoUnit.HOURS);
    }

    public static Instant plusDays(Instant instant, long days) {
        return KiwiInstants.plus(instant, days, ChronoUnit.DAYS);
    }

    private static Instant plus(Instant instant, long value, TemporalUnit unit) {
        return instant.plus(value, unit);
    }

    public static Instant plusMonths(Instant instant, long months) {
        return KiwiInstants.plusUsingZDT(instant, months, ChronoUnit.MONTHS);
    }

    public static Instant plusYears(Instant instant, long years) {
        return KiwiInstants.plusUsingZDT(instant, years, ChronoUnit.YEARS);
    }

    public static Instant plusUsingZDT(Instant instant, long amountToAdd, TemporalUnit unit) {
        return KiwiInstants.toZonedDateTime(instant).plus(amountToAdd, unit).toInstant();
    }

    private static ZonedDateTime toZonedDateTime(Instant instant) {
        return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    private KiwiInstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

