/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;

public final class KiwiObjects {
    @SafeVarargs
    public static <T> T firstNonNullOrNull(T first, T second, T ... rest) {
        return KiwiObjects.firstNonNull(first, second, rest).orElse(null);
    }

    @SafeVarargs
    public static <T> T firstSuppliedNonNullOrNull(Supplier<T> first, Supplier<T> second, Supplier<T> ... rest) {
        return KiwiObjects.firstSuppliedNonNull(first, second, rest).orElse(null);
    }

    @SafeVarargs
    public static <T> Optional<T> firstNonNull(T first, T second, T ... rest) {
        if (Objects.nonNull(first)) {
            return Optional.of(first);
        }
        if (Objects.nonNull(second)) {
            return Optional.of(second);
        }
        return Arrays.stream(rest).filter(Objects::nonNull).findFirst();
    }

    @SafeVarargs
    public static <T> Optional<T> firstSuppliedNonNull(Supplier<T> first, Supplier<T> second, Supplier<T> ... rest) {
        T firstT = first.get();
        if (Objects.nonNull(firstT)) {
            return Optional.of(firstT);
        }
        T secondT = second.get();
        if (Objects.nonNull(secondT)) {
            return Optional.of(secondT);
        }
        return Arrays.stream(rest).map(Supplier::get).filter(Objects::nonNull).findFirst();
    }

    @Generated
    private KiwiObjects() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

