/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import com.google.common.base.Preconditions;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import lombok.Generated;

public final class KiwiPrimitives {
    public static int firstNonZero(int first, int second) {
        return first != 0 ? first : (int)KiwiPrimitives.checkNonZero(second);
    }

    public static long firstNonZero(long first, long second) {
        return first != 0L ? first : KiwiPrimitives.checkNonZero(second);
    }

    private static long checkNonZero(long value) {
        Preconditions.checkArgument((value != 0L ? 1 : 0) != 0, (Object)"One of the arguments must be non-zero");
        return value;
    }

    public static Integer tryParseIntOrNull(CharSequence cs) {
        try {
            return Integer.valueOf(cs.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static OptionalInt tryParseInt(CharSequence cs) {
        try {
            return OptionalInt.of(Integer.parseInt(cs.toString()));
        }
        catch (Exception e) {
            return OptionalInt.empty();
        }
    }

    public static int tryParseIntOrThrow(CharSequence cs) {
        try {
            return Integer.parseInt(cs.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Long tryParseLongOrNull(CharSequence cs) {
        try {
            return Long.valueOf(cs.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static OptionalLong tryParseLong(CharSequence cs) {
        try {
            return OptionalLong.of(Long.parseLong(cs.toString()));
        }
        catch (Exception e) {
            return OptionalLong.empty();
        }
    }

    public static long tryParseLongOrThrow(CharSequence cs) {
        try {
            return Long.parseLong(cs.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Double tryParseDoubleOrNull(CharSequence cs) {
        try {
            return Double.valueOf(cs.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static OptionalDouble tryParseDouble(CharSequence cs) {
        try {
            return OptionalDouble.of(Double.parseDouble(cs.toString()));
        }
        catch (Exception e) {
            return OptionalDouble.empty();
        }
    }

    public static double tryParseDoubleOrThrow(CharSequence cs) {
        try {
            return Double.parseDouble(cs.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean booleanFromLong(long value) {
        return KiwiPrimitives.booleanFromLong(value, BooleanConversionOption.ZERO_OR_ONE);
    }

    public static boolean booleanFromLong(long value, BooleanConversionOption option) {
        return switch (option) {
            default -> throw new IncompatibleClassChangeError();
            case BooleanConversionOption.ZERO_OR_ONE -> {
                Preconditions.checkArgument((value == 0L || value == 1L ? 1 : 0) != 0, (String)"value must be 0 or 1, but found %s", (long)value);
                if (value == 1L) {
                    yield true;
                }
                yield false;
            }
            case BooleanConversionOption.NON_ZERO_AS_TRUE -> value != 0L;
        };
    }

    public static boolean booleanFromInt(int value) {
        return KiwiPrimitives.booleanFromInt(value, BooleanConversionOption.ZERO_OR_ONE);
    }

    public static boolean booleanFromInt(int value, BooleanConversionOption option) {
        return switch (option) {
            default -> throw new IncompatibleClassChangeError();
            case BooleanConversionOption.ZERO_OR_ONE -> {
                Preconditions.checkArgument((value == 0 || value == 1 ? 1 : 0) != 0, (String)"value must be 0 or 1, but found %s", (int)value);
                if (value == 1) {
                    yield true;
                }
                yield false;
            }
            case BooleanConversionOption.NON_ZERO_AS_TRUE -> value != 0;
        };
    }

    @Generated
    private KiwiPrimitives() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum BooleanConversionOption {
        ZERO_OR_ONE,
        NON_ZERO_AS_TRUE;

    }
}

