/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;

public final class Versions {
    public static String higherVersion(String left, String right) {
        return Versions.versionCompare(left, right) >= 0 ? left : right;
    }

    public static boolean isStrictlyHigherVersion(String left, String right) {
        return Versions.versionCompare(left, right) > 0;
    }

    public static boolean isHigherOrSameVersion(String left, String right) {
        return Versions.versionCompare(left, right) >= 0;
    }

    public static boolean isStrictlyLowerVersion(String left, String right) {
        return Versions.versionCompare(left, right) < 0;
    }

    public static boolean isLowerOrSameVersion(String left, String right) {
        return Versions.versionCompare(left, right) <= 0;
    }

    public static boolean isSameVersion(String left, String right) {
        return Versions.versionCompare(left, right) == 0;
    }

    public static int versionCompare(String left, String right) {
        String[] rightParts;
        KiwiPreconditions.checkArgumentNotBlank(left, "left version cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(right, "right version cannot be blank");
        if (left.equals(right)) {
            return 0;
        }
        String[] leftParts = Versions.lowerCaseAndSplit(left);
        int pos = Versions.indexOfFirstUnequalOrLastCommonSegment(leftParts, rightParts = Versions.lowerCaseAndSplit(right));
        if (pos < leftParts.length && pos < rightParts.length) {
            return Versions.contextuallyCompare(leftParts[pos], rightParts[pos]);
        }
        if (Versions.allAreNumericIn(leftParts) && Versions.allAreNumericIn(rightParts)) {
            return Integer.signum(leftParts.length - rightParts.length);
        }
        return Integer.signum(rightParts.length - leftParts.length);
    }

    private static int indexOfFirstUnequalOrLastCommonSegment(String[] leftParts, String[] rightParts) {
        int pos;
        for (pos = 0; pos < leftParts.length && pos < rightParts.length && leftParts[pos].equals(rightParts[pos]); ++pos) {
        }
        return pos;
    }

    private static String[] lowerCaseAndSplit(String version) {
        return version.toLowerCase().split("[.-]");
    }

    private static int contextuallyCompare(String leftPart, String rightPart) {
        if (StringUtils.isNumeric((CharSequence)leftPart) && StringUtils.isNumeric((CharSequence)rightPart)) {
            return Versions.compareNumeric(leftPart, rightPart);
        }
        return Versions.compareString(leftPart, rightPart);
    }

    private static int compareNumeric(String leftPart, String rightPart) {
        int diff = Integer.valueOf(leftPart).compareTo(Integer.valueOf(rightPart));
        return Integer.signum(diff);
    }

    private static int compareString(String leftPart, String rightPart) {
        int result = StringUtils.compare((String)leftPart, (String)rightPart);
        return Integer.compare(result, 0);
    }

    private static boolean allAreNumericIn(String[] elements) {
        return Arrays.stream(elements).allMatch(StringUtils::isNumeric);
    }

    @Generated
    private Versions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

