/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base.process;

import java.util.Objects;

public enum KillSignal {
    SIGHUP(1),
    SIGINT(2),
    SIGQUIT(3),
    SIGKILL(9),
    SIGTERM(15);

    private static final char DASH = '-';
    public final int signalNumber;

    private KillSignal(int number) {
        this.signalNumber = number;
    }

    public String number() {
        return String.valueOf(this.signalNumber);
    }

    public static String withLeadingDash(String signal) {
        Objects.requireNonNull(signal);
        if (signal.charAt(0) == '-') {
            return signal;
        }
        return "-" + signal;
    }

    public String withLeadingDash() {
        return KillSignal.withLeadingDash(this.number());
    }
}

