/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import lombok.Generated;
import org.kiwiproject.collect.KiwiLists;

public final class KiwiCollections {
    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotNullOrEmpty(Collection<T> collection) {
        return !KiwiCollections.isNullOrEmpty(collection);
    }

    public static <T> boolean hasOneElement(Collection<T> collection) {
        return Objects.nonNull(collection) && collection.size() == 1;
    }

    public static <T> Optional<T> firstIfPresent(Collection<T> sequencedCollection) {
        return KiwiCollections.isNotNullOrEmpty(sequencedCollection) ? Optional.of(KiwiCollections.first(sequencedCollection)) : Optional.empty();
    }

    public static <T> T first(Collection<T> sequencedCollection) {
        KiwiCollections.checkNotEmptyCollection(sequencedCollection);
        KiwiCollections.checkIsSequenced(sequencedCollection);
        if (sequencedCollection instanceof SortedSet) {
            return KiwiCollections.first((SortedSet)sequencedCollection);
        }
        if (sequencedCollection instanceof LinkedHashSet) {
            return KiwiCollections.first((LinkedHashSet)sequencedCollection);
        }
        if (sequencedCollection instanceof List) {
            return KiwiLists.first((List)sequencedCollection);
        }
        Preconditions.checkState((boolean)(sequencedCollection instanceof Deque), (String)"expected Deque but was %s", sequencedCollection.getClass());
        return KiwiCollections.first((Deque)sequencedCollection);
    }

    private static <T> T first(SortedSet<T> sortedSet) {
        return sortedSet.first();
    }

    private static <T> T first(LinkedHashSet<T> linkedHashSet) {
        return (T)linkedHashSet.iterator().next();
    }

    private static <T> T first(Deque<T> deque) {
        return deque.peekFirst();
    }

    public static <T> Optional<T> lastIfPresent(Collection<T> sequencedCollection) {
        return KiwiCollections.isNotNullOrEmpty(sequencedCollection) ? Optional.of(KiwiCollections.last(sequencedCollection)) : Optional.empty();
    }

    public static <T> T last(Collection<T> sequencedCollection) {
        KiwiCollections.checkNotEmptyCollection(sequencedCollection);
        KiwiCollections.checkIsSequenced(sequencedCollection);
        if (sequencedCollection instanceof SortedSet) {
            return KiwiCollections.last((SortedSet)sequencedCollection);
        }
        if (sequencedCollection instanceof LinkedHashSet) {
            return KiwiCollections.last((LinkedHashSet)sequencedCollection);
        }
        if (sequencedCollection instanceof List) {
            return KiwiLists.last((List)sequencedCollection);
        }
        Preconditions.checkState((boolean)(sequencedCollection instanceof Deque), (String)"expected Deque but was %s", sequencedCollection.getClass());
        return KiwiCollections.last((Deque)sequencedCollection);
    }

    private static <T> T last(SortedSet<T> sortedSet) {
        return sortedSet.last();
    }

    private static <T> T last(LinkedHashSet<T> linkedHashSet) {
        int size = linkedHashSet.size();
        return linkedHashSet.stream().skip((long)size - 1L).findFirst().orElse(null);
    }

    private static <T> T last(Deque<T> deque) {
        return deque.peekLast();
    }

    public static <T> void checkNotEmptyCollection(Collection<T> collection) {
        Preconditions.checkArgument((boolean)KiwiCollections.isNotNullOrEmpty(collection), (Object)"collection must contain at least one element");
    }

    public static <T> void checkNonNullCollection(Collection<T> collection) {
        Preconditions.checkNotNull(collection, (Object)"collection must not be null");
    }

    private static <T> void checkIsSequenced(Collection<T> collection) {
        Preconditions.checkArgument((boolean)KiwiCollections.isSequenced(collection), (String)"collection of type %s is not supported as a 'sequenced' collection", (Object)Optional.ofNullable(collection).map(coll -> coll.getClass().getName()).orElse("null collection"));
    }

    public static <T> boolean isSequenced(Collection<T> collection) {
        return collection instanceof SortedSet || collection instanceof LinkedHashSet || collection instanceof List || collection instanceof Deque;
    }

    @Generated
    private KiwiCollections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

