/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;

public final class KiwiMaps {
    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> boolean isNotNullOrEmpty(Map<K, V> map) {
        return !KiwiMaps.isNullOrEmpty(map);
    }

    public static <K, V> Map<K, V> newUnmodifiableHashMap(Object ... items) {
        return Collections.unmodifiableMap(KiwiMaps.newHashMap(items));
    }

    public static <K, V> Map<K, V> newHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        HashMap map = new HashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K, V> Map<K, V> newUnmodifiableLinkedHashMap(Object ... items) {
        return Collections.unmodifiableMap(KiwiMaps.newLinkedHashMap(items));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        LinkedHashMap map = new LinkedHashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K extends Comparable<? super K>, V> SortedMap<K, V> newUnmodifiableTreeMap(Object ... items) {
        SortedMap<K, V> sortedMap = KiwiMaps.newTreeMap(items);
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static <K extends Comparable<? super K>, V> SortedMap<K, V> newTreeMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        TreeMap map = new TreeMap();
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K, V> Map<K, V> newUnmodifiableConcurrentHashMap(Object ... items) {
        return Collections.unmodifiableMap(KiwiMaps.newConcurrentHashMap(items));
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        ConcurrentHashMap map = new ConcurrentHashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    private static <K, V> void populate(Map<K, V> map, Object ... items) {
        for (int i = 0; i < items.length; i += 2) {
            Object key = items[i];
            Object value = items[i + 1];
            map.put(key, value);
        }
    }

    public static <K, V> boolean keyExistsWithNullValue(Map<K, V> map, K key) {
        return KiwiMaps.keyExists(map, key) && Objects.isNull(map.get(key));
    }

    public static <K, V> boolean keyExistsWithNonNullValue(Map<K, V> map, K key) {
        return KiwiMaps.keyExists(map, key) && Objects.nonNull(map.get(key));
    }

    private static <K, V> boolean keyExists(Map<K, V> map, K key) {
        return KiwiMaps.isNotNullOrEmpty(map) && map.containsKey(key);
    }

    public static <K, V> V getOrThrow(Map<K, V> map, K key) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        if (map.containsKey(key)) {
            V v = map.get(key);
            if (Objects.isNull(v)) {
                throw new NoSuchElementException(KiwiStrings.f("value associated with key '{}' is null", key));
            }
            return v;
        }
        throw new NoSuchElementException(KiwiStrings.f("key '{}' does not exist in map", key));
    }

    public static <K, V, E extends RuntimeException> V getOrThrow(Map<K, V> map, K key, Supplier<E> exceptionSupplier) {
        return KiwiMaps.getOrThrowChecked(map, key, exceptionSupplier);
    }

    public static <K, V, E extends Exception> V getOrThrowChecked(Map<K, V> map, K key, Supplier<E> exceptionSupplier) throws E {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiPreconditions.checkArgumentNotNull(exceptionSupplier, "exceptionSupplier must not be null");
        if (map.containsKey(key)) {
            V v = map.get(key);
            if (Objects.isNull(v)) {
                throw (Exception)exceptionSupplier.get();
            }
            return v;
        }
        throw (Exception)exceptionSupplier.get();
    }

    private static <K, V> void checkMapAndKeyArgsNotNull(Map<K, V> map, K key) {
        KiwiPreconditions.checkArgumentNotNull(map, "map must not be null");
        KiwiPreconditions.checkArgumentNotNull(key, "key must not be null");
    }

    @Generated
    private KiwiMaps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

