/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiStreams {
    public static <T> Optional<T> findFirst(Stream<?> stream, Class<T> typeToFind) {
        return KiwiStreams.findFirst(stream, typeToFind, obj -> true);
    }

    public static <T> Optional<T> findFirst(Stream<?> stream, Class<T> typeToFind, Predicate<T> predicate) {
        return stream.filter(obj -> typeToFind.isAssignableFrom(obj.getClass())).map(typeToFind::cast).filter(predicate).findFirst();
    }

    public static <T> Stream<T> stream(Collection<T> collection, StreamMode mode) {
        KiwiPreconditions.checkArgumentNotNull(collection);
        KiwiPreconditions.checkArgumentNotNull(mode);
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case StreamMode.SEQUENTIAL -> collection.stream();
            case StreamMode.PARALLEL -> collection.parallelStream();
        };
    }

    @Generated
    private KiwiStreams() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum StreamMode {
        SEQUENTIAL,
        PARALLEL;

    }
}

