/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.config.EndpointConfiguration;
import org.kiwiproject.config.SSLContextConfiguration;

public class SecureEndpointsConfiguration
extends SSLContextConfiguration {
    private List<EndpointConfiguration> endpoints = new ArrayList<EndpointConfiguration>();

    public static Builder builder() {
        return new Builder();
    }

    public boolean isSecure() {
        return this.endpoints.stream().anyMatch(EndpointConfiguration::isSecure);
    }

    public boolean anyEndpointSecure() {
        return this.isSecure();
    }

    public boolean allEndpointsSecure() {
        return this.endpoints.stream().allMatch(EndpointConfiguration::isSecure);
    }

    public EndpointConfiguration getEndpointByTag(String tag) {
        return this.getEndpointByTagOrEmpty(tag).orElseThrow(SecureEndpointsConfiguration.endpointNotExistsException("tag", tag));
    }

    public Optional<EndpointConfiguration> getEndpointByTagOrEmpty(String tag) {
        return this.endpoints.stream().filter(endpoint -> endpoint.getTag().equalsIgnoreCase(tag)).findFirst();
    }

    public EndpointConfiguration getEndpointByPathEnding(String pathEnding) {
        return this.getEndpointByPathEndingOrEmpty(pathEnding).orElseThrow(SecureEndpointsConfiguration.endpointNotExistsException("pathEnding", pathEnding));
    }

    public Optional<EndpointConfiguration> getEndpointByPathEndingOrEmpty(String pathEnding) {
        return this.endpoints.stream().filter(endpoint -> endpoint.getPath().endsWith(pathEnding)).findFirst();
    }

    private static Supplier<IllegalStateException> endpointNotExistsException(String classifier, String value) {
        return () -> new IllegalStateException(KiwiStrings.f("No endpoint by {} with value [{}] was found", classifier, value));
    }

    @Generated
    public List<EndpointConfiguration> getEndpoints() {
        return this.endpoints;
    }

    @Generated
    public void setEndpoints(List<EndpointConfiguration> endpoints) {
        this.endpoints = endpoints;
    }

    public static class Builder
    extends SSLContextConfiguration.Builder {
        private final SecureEndpointsConfiguration configuration = new SecureEndpointsConfiguration();

        public EndpointConfiguration.Builder addEndpoint() {
            return EndpointConfiguration.builder(this);
        }

        @Override
        public Builder keyStorePath(String keyStorePath) {
            return this.setKeyStorePath(keyStorePath);
        }

        @Override
        public Builder setKeyStorePath(String keyStorePath) {
            this.configuration.setKeyStorePath(keyStorePath);
            return this;
        }

        @Override
        public Builder keyStorePassword(String keyStorePassword) {
            return this.setKeyStorePassword(keyStorePassword);
        }

        @Override
        public Builder setKeyStorePassword(String keyStorePassword) {
            this.configuration.setKeyStorePassword(keyStorePassword);
            return this;
        }

        @Override
        public Builder trustStorePath(String trustStorePath) {
            return this.setTrustStorePath(trustStorePath);
        }

        @Override
        public Builder setTrustStorePath(String trustStorePath) {
            this.configuration.setTrustStorePath(trustStorePath);
            return this;
        }

        @Override
        public Builder trustStorePassword(String trustStorePassword) {
            return this.setTrustStorePassword(trustStorePassword);
        }

        @Override
        public Builder setTrustStorePassword(String trustStorePassword) {
            this.configuration.setTrustStorePassword(trustStorePassword);
            return this;
        }

        @Override
        public Builder protocol(String protocol) {
            return this.setProtocol(protocol);
        }

        @Override
        public Builder setProtocol(String protocol) {
            this.configuration.setProtocol(protocol);
            return this;
        }

        @Override
        public Builder keyStoreType(String keyStoreType) {
            return this.setKeyStoreType(keyStoreType);
        }

        @Override
        public Builder setKeyStoreType(String keyStoreType) {
            this.configuration.setKeyStoreType(keyStoreType);
            return this;
        }

        @Override
        public Builder trustStoreType(String trustStoreType) {
            return this.setTrustStoreType(trustStoreType);
        }

        @Override
        public Builder setTrustStoreType(String trustStoreType) {
            this.configuration.setTrustStoreType(trustStoreType);
            return this;
        }

        @Override
        public Builder verifyHostname(boolean verifyHostname) {
            return this.setVerifyHostname(verifyHostname);
        }

        @Override
        public Builder setVerifyHostname(boolean verifyHostname) {
            this.configuration.setVerifyHostname(verifyHostname);
            return this;
        }

        @Override
        public SecureEndpointsConfiguration build() {
            return this.configuration;
        }

        @Generated
        Builder() {
        }
    }
}

