/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.dropwizard.jdbi3;

import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.h2.H2DatabasePlugin;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.kiwiproject.dropwizard.jdbi3.Jdbi3Helpers;

enum DatabaseType {
    H2(H2DatabasePlugin.class.getName()),
    POSTGRES("org.jdbi.v3.postgres.PostgresPlugin");

    private final String pluginClassName;

    private DatabaseType(String pluginClassName) {
        this.pluginClassName = pluginClassName;
    }

    static Optional<JdbiPlugin> pluginFromDatabaseUrl(String databaseUrl) {
        return DatabaseType.databaseTypeFromDatabaseUrl(databaseUrl).flatMap(databaseType -> Jdbi3Helpers.getPluginInstance(databaseType.getPluginClassName()));
    }

    static Optional<DatabaseType> databaseTypeFromDatabaseUrl(String databaseUrl) {
        if (databaseUrl.startsWith("jdbc:postgresql:")) {
            return Optional.of(POSTGRES);
        }
        if (databaseUrl.startsWith("jdbc:h2:")) {
            return Optional.of(H2);
        }
        return Optional.empty();
    }

    @Generated
    public String getPluginClassName() {
        return this.pluginClassName;
    }
}

