/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jackson.ser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ListToCsvStringDeserializer
extends StdDeserializer<String> {
    public ListToCsvStringDeserializer() {
        super(String.class);
    }

    public String deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectCodec codec = parser.getCodec();
        Preconditions.checkState((boolean)Objects.nonNull(codec), (Object)"There is no codec associated with the parser; a codec is required to read the content as a tree");
        TreeNode treeNode = codec.readTree(parser);
        if (treeNode.isContainerNode()) {
            return ListToCsvStringDeserializer.containerNodeToCsvString(treeNode);
        }
        return ListToCsvStringDeserializer.verifyIsTextNode(treeNode).asText();
    }

    private static String containerNodeToCsvString(TreeNode treeNode) {
        return IntStream.range(0, treeNode.size()).mapToObj(index -> ListToCsvStringDeserializer.textNodeToString(treeNode, index)).collect(Collectors.joining(","));
    }

    private static String textNodeToString(TreeNode treeNode, int index) {
        TreeNode node = treeNode.get(index);
        return ListToCsvStringDeserializer.verifyIsTextNode(node).asText();
    }

    private static TextNode verifyIsTextNode(TreeNode node) {
        Verify.verify((boolean)(node instanceof TextNode), (String)"expected node to be TextNode but was: %s", (Object)node.getClass().getName());
        return (TextNode)node;
    }
}

