/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;

public final class KiwiMultivaluedMaps {
    public static MultivaluedMap<String, String> newMultivaluedMap(String ... items) {
        return KiwiMultivaluedMaps.newMultivaluedMap((MultivaluedMap<String, String> accumulator, List<String> kvPair) -> accumulator.add((Object)((String)KiwiLists.first(kvPair)), (Object)((String)KiwiLists.second(kvPair))), items);
    }

    public static MultivaluedMap<String, String> newSingleValuedParameterMap(String ... items) {
        return KiwiMultivaluedMaps.newMultivaluedMap((MultivaluedMap<String, String> accumulator, List<String> kvPair) -> accumulator.putSingle((Object)((String)KiwiLists.first(kvPair)), (Object)((String)KiwiLists.second(kvPair))), items);
    }

    private static MultivaluedMap<String, String> newMultivaluedMap(BiConsumer<MultivaluedMap<String, String>, List<String>> consumer, String ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        MultivaluedHashMap accumulator = new MultivaluedHashMap();
        List kvPairs = Lists.partition(List.of(items), (int)2);
        kvPairs.forEach(kvPair -> consumer.accept((MultivaluedMap<String, String>)accumulator, (List<String>)kvPair));
        return accumulator;
    }

    public static Map<String, String> toSingleValuedParameterMap(MultivaluedMap<String, String> original) {
        KiwiPreconditions.checkArgumentNotNull(original, "original map cannot be null");
        HashMap singleValuedMap = Maps.newHashMapWithExpectedSize((int)original.keySet().size());
        for (String key : original.keySet()) {
            singleValuedMap.put(key, (String)original.getFirst((Object)key));
        }
        return singleValuedMap;
    }

    public static Multimap<String, String> toMultimap(MultivaluedMap<String, String> original) {
        KiwiPreconditions.checkArgumentNotNull(original, "original map cannot be null");
        ArrayListMultimap multimap = ArrayListMultimap.create();
        original.forEach((x$0, x$1) -> multimap.putAll(x$0, x$1));
        return multimap;
    }

    @Generated
    private KiwiMultivaluedMaps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

