/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs.client;

import com.google.common.base.Preconditions;
import jakarta.ws.rs.client.Client;
import java.time.Duration;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiJerseyClients {
    public static Client connectTimeout(Client client, io.dropwizard.util.Duration timeout) {
        KiwiJerseyClients.checkTimeoutNotNull(timeout);
        return KiwiJerseyClients.connectTimeout(client, timeout.toMilliseconds());
    }

    public static Client connectTimeout(Client client, Duration timeout) {
        KiwiJerseyClients.checkTimeoutNotNull(timeout);
        return KiwiJerseyClients.connectTimeout(client, timeout.toMillis());
    }

    public static Client connectTimeout(Client client, long timeoutMillis) {
        KiwiJerseyClients.checkTimeout(timeoutMillis);
        return KiwiJerseyClients.connectTimeout(client, Math.toIntExact(timeoutMillis));
    }

    public static Client connectTimeout(Client client, int timeoutMillis) {
        client.property("jersey.config.client.connectTimeout", (Object)timeoutMillis);
        return client;
    }

    public static Client readTimeout(Client client, io.dropwizard.util.Duration timeout) {
        KiwiJerseyClients.checkTimeoutNotNull(timeout);
        return KiwiJerseyClients.readTimeout(client, timeout.toMilliseconds());
    }

    public static Client readTimeout(Client client, Duration timeout) {
        KiwiJerseyClients.checkTimeoutNotNull(timeout);
        return KiwiJerseyClients.readTimeout(client, timeout.toMillis());
    }

    private static void checkTimeoutNotNull(Object timeout) {
        KiwiPreconditions.checkArgumentNotNull(timeout, "timeout must not be null");
    }

    public static Client readTimeout(Client client, long timeoutMillis) {
        KiwiJerseyClients.checkTimeout(timeoutMillis);
        return KiwiJerseyClients.readTimeout(client, Math.toIntExact(timeoutMillis));
    }

    public static Client readTimeout(Client client, int timeoutMillis) {
        client.property("jersey.config.client.readTimeout", (Object)timeoutMillis);
        return client;
    }

    public static void checkTimeout(long timeoutMillis) {
        Preconditions.checkArgument((timeoutMillis <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"timeout must be convertible to an int but %s is more than Integer.MAX_VALUE. See Jersey API docs for CONNECT_TIMEOUT and READ_TIMEOUT in ClientProperties", (long)timeoutMillis);
    }

    @Generated
    private KiwiJerseyClients() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

