/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs.client;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiArrays;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.collect.KiwiMaps;

@Beta
public class WebTargetHelper
implements WebTarget {
    private final WebTarget webTarget;

    WebTargetHelper(WebTarget webTarget) {
        this.webTarget = KiwiPreconditions.requireNotNull(webTarget, "webTarget must not be null", new Object[0]);
    }

    @VisibleForTesting
    WebTarget wrapped() {
        return this.webTarget;
    }

    public WebTarget toWebTarget() {
        return this.webTarget.path("");
    }

    public static WebTargetHelper withWebTarget(WebTarget webTarget) {
        return new WebTargetHelper(webTarget);
    }

    public WebTargetHelper queryParamRequireNotNull(String name, Object value) {
        KiwiPreconditions.checkArgumentNotBlank(name, "name cannot be blank");
        KiwiPreconditions.checkArgumentNotNull(value, "value cannot be null for parameter %s", name);
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamIfNotNull(String name, Object value) {
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(value)) {
            return this;
        }
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamFilterNotNull(String name, Object ... values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiArrays.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotNull(name, Arrays.stream(values));
    }

    public WebTargetHelper queryParamFilterNotNull(String name, List<Object> values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiLists.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotNull(name, values.stream());
    }

    public WebTargetHelper queryParamFilterNotNull(String name, Stream<Object> stream) {
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(stream)) {
            return this;
        }
        Object[] nonNullValues = stream.filter(Objects::nonNull).toArray();
        WebTarget newWebTarget = this.webTarget.queryParam(name, nonNullValues);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamRequireNotBlank(String name, String value) {
        KiwiPreconditions.checkArgumentNotBlank(name, "name cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(value, "value cannot be blank for parameter %s", name);
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamIfNotBlank(String name, String value) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)value)) {
            return this;
        }
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamFilterNotBlank(String name, String ... values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiArrays.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotBlank(name, Arrays.stream(values));
    }

    public WebTargetHelper queryParamFilterNotBlank(String name, List<String> values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiLists.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotBlank(name, values.stream());
    }

    public WebTargetHelper queryParamFilterNotBlank(String name, Stream<String> stream) {
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(stream)) {
            return this;
        }
        Object[] nonBlankValues = stream.filter(StringUtils::isNotBlank).toArray();
        WebTarget newWebTarget = this.webTarget.queryParam(name, nonBlankValues);
        return new WebTargetHelper(newWebTarget);
    }

    public <V> WebTargetHelper queryParamsFromMap(Map<String, V> parameters) {
        if (KiwiMaps.isNullOrEmpty(parameters)) {
            return this;
        }
        WebTargetHelper targetHelper = this;
        for (Map.Entry<String, V> entry : parameters.entrySet()) {
            targetHelper = targetHelper.queryParamIfNotNull(entry.getKey(), entry.getValue());
        }
        return targetHelper;
    }

    public <V> WebTargetHelper queryParamsFromMultivaluedMap(MultivaluedMap<String, V> parameters) {
        if (Objects.isNull(parameters) || parameters.isEmpty()) {
            return this;
        }
        WebTargetHelper targetHelper = this;
        for (Map.Entry entry : parameters.entrySet()) {
            targetHelper = targetHelper.queryParamFilterNotNull((String)entry.getKey(), (List)entry.getValue());
        }
        return targetHelper;
    }

    public URI getUri() {
        return this.webTarget.getUri();
    }

    public UriBuilder getUriBuilder() {
        return this.webTarget.getUriBuilder();
    }

    public WebTargetHelper path(String path) {
        WebTarget newWebTarget = this.webTarget.path(path);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper resolveTemplate(String name, Object value) {
        WebTarget newWebTarget = this.webTarget.resolveTemplate(name, value);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper resolveTemplate(String name, Object value, boolean encodeSlashInPath) {
        WebTarget newWebTarget = this.webTarget.resolveTemplate(name, value, encodeSlashInPath);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper resolveTemplateFromEncoded(String name, Object value) {
        WebTarget newWebTarget = this.webTarget.resolveTemplateFromEncoded(name, value);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper resolveTemplates(Map<String, Object> templateValues) {
        WebTarget newWebTarget = this.webTarget.resolveTemplates(templateValues);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) {
        WebTarget newWebTarget = this.webTarget.resolveTemplates(templateValues, encodeSlashInPath);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper resolveTemplatesFromEncoded(Map<String, Object> templateValues) {
        WebTarget newWebTarget = this.webTarget.resolveTemplatesFromEncoded(templateValues);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper matrixParam(String name, Object ... values) {
        WebTarget newWebTarget = this.webTarget.matrixParam(name, values);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParam(String name, Object ... values) {
        WebTarget newWebTarget = this.webTarget.queryParam(name, values);
        return new WebTargetHelper(newWebTarget);
    }

    public Invocation.Builder request() {
        return this.webTarget.request();
    }

    public Invocation.Builder request(String ... acceptedResponseTypes) {
        return this.webTarget.request(acceptedResponseTypes);
    }

    public Invocation.Builder request(MediaType ... acceptedResponseTypes) {
        return this.webTarget.request(acceptedResponseTypes);
    }

    public Configuration getConfiguration() {
        return this.webTarget.getConfiguration();
    }

    public WebTargetHelper property(String name, Object value) {
        this.webTarget.property(name, value);
        return this;
    }

    public WebTargetHelper register(Class<?> componentClass) {
        this.webTarget.register(componentClass);
        return this;
    }

    public WebTargetHelper register(Class<?> componentClass, int priority) {
        this.webTarget.register(componentClass, priority);
        return this;
    }

    public WebTargetHelper register(Class<?> componentClass, Class<?> ... contracts) {
        this.webTarget.register(componentClass, (Class[])contracts);
        return this;
    }

    public WebTargetHelper register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.webTarget.register(componentClass, contracts);
        return this;
    }

    public WebTargetHelper register(Object component) {
        this.webTarget.register(component);
        return this;
    }

    public WebTargetHelper register(Object component, int priority) {
        this.webTarget.register(component, priority);
        return this;
    }

    public WebTargetHelper register(Object component, Class<?> ... contracts) {
        this.webTarget.register(component, (Class[])contracts);
        return this;
    }

    public WebTargetHelper register(Object component, Map<Class<?>, Integer> contracts) {
        this.webTarget.register(component, contracts);
        return this;
    }
}

