/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs.exception;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.jaxrs.exception.ErrorMessage;
import org.kiwiproject.jaxrs.exception.JaxrsException;
import org.kiwiproject.json.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JaxrsExceptionMapper
implements ExceptionMapper<JaxrsException> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(JaxrsExceptionMapper.class);
    public static final String KEY_ERRORS = "errors";
    private static final JsonHelper JSON_HELPER = JsonHelper.newDropwizardJsonHelper();

    public Response toResponse(JaxrsException exception) {
        return JaxrsExceptionMapper.buildResponse(exception);
    }

    public static Response buildResponse(JaxrsException exception) {
        return JaxrsExceptionMapper.buildResponseBuilder(exception).build();
    }

    public static Response.ResponseBuilder buildResponseBuilder(JaxrsException exception) {
        return Response.status((int)exception.getStatusCode()).entity(JaxrsExceptionMapper.buildResponseEntity(exception)).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public static Map<String, Object> buildResponseEntity(JaxrsException exception) {
        HashMap<String, Object> entity = new HashMap<String, Object>();
        if (KiwiMaps.isNotNullOrEmpty(exception.getOtherData())) {
            entity.putAll(exception.getOtherData());
        }
        entity.put(KEY_ERRORS, exception.getErrors());
        return entity;
    }

    public static JaxrsException toJaxrsException(Response response) {
        Map<String, Object> entity;
        String entityText;
        if (Objects.isNull(response)) {
            return null;
        }
        int status = response.getStatus();
        if (!response.hasEntity()) {
            return new JaxrsException(response.getStatusInfo().getReasonPhrase(), status);
        }
        try {
            entityText = (String)response.readEntity(String.class);
            if (StringUtils.isBlank((CharSequence)entityText)) {
                return new JaxrsException(response.getStatusInfo().getReasonPhrase(), status);
            }
        }
        catch (Exception e) {
            LOG.warn("Error reading entity from response", (Throwable)e);
            return new JaxrsException((String)null, status);
        }
        try {
            entity = JSON_HELPER.toMap(entityText);
        }
        catch (Exception e) {
            LOG.warn("Error converting response text to Map<String, Object>", (Throwable)e);
            return new JaxrsException(entityText, status);
        }
        return JaxrsExceptionMapper.toJaxrsException(status, entity);
    }

    public static JaxrsException toJaxrsException(int status, Map<String, Object> entity) {
        if (KiwiMaps.isNullOrEmpty(entity) || !entity.containsKey(KEY_ERRORS)) {
            JaxrsException ex = new JaxrsException((String)null, status);
            ex.setOtherData(entity);
            return ex;
        }
        try {
            List<ErrorMessage> errorMessages = JaxrsExceptionMapper.extractErrorMessages(entity);
            JaxrsException ex = new JaxrsException(errorMessages, (Integer)status);
            HashMap<String, Object> otherData = new HashMap<String, Object>(entity);
            otherData.remove(KEY_ERRORS);
            otherData.remove(null);
            ex.setOtherData(Collections.unmodifiableMap(otherData));
            return ex;
        }
        catch (Exception e) {
            LOG.warn("Error converting given entity map: {}", entity, (Object)e);
            return new JaxrsException((String)null, status);
        }
    }

    private static List<ErrorMessage> extractErrorMessages(Map<String, Object> entity) {
        if (entity.containsKey(KEY_ERRORS)) {
            List errorObjects = (List)entity.get(KEY_ERRORS);
            return errorObjects.stream().map(JaxrsExceptionMapper::toErrorMessageOrNull).filter(Objects::nonNull).toList();
        }
        return List.of();
    }

    private static ErrorMessage toErrorMessageOrNull(Object obj) {
        if (obj instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)obj;
            return errorMessage;
        }
        if (obj instanceof Map) {
            return ErrorMessage.valueOf((Map)obj);
        }
        return null;
    }
}

