/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jsch;

import com.jcraft.jsch.Logger;
import org.slf4j.LoggerFactory;

public class JSchSlf4jLogger
implements Logger {
    private final org.slf4j.Logger slf4jLogger;

    public JSchSlf4jLogger() {
        this.slf4jLogger = LoggerFactory.getLogger(JSchSlf4jLogger.class);
    }

    public JSchSlf4jLogger(org.slf4j.Logger slf4jLogger) {
        this.slf4jLogger = slf4jLogger;
    }

    public boolean isEnabled(int level) {
        return switch (level) {
            case 0, 1 -> this.slf4jLogger.isDebugEnabled();
            case 2 -> this.slf4jLogger.isWarnEnabled();
            case 3, 4 -> this.slf4jLogger.isErrorEnabled();
            default -> {
                this.slf4jLogger.error("Was passed invalid level: {}", (Object)level);
                yield false;
            }
        };
    }

    public void log(int level, String message) {
        if (this.isValidLevel(level) && this.isNotEnabled(level)) {
            return;
        }
        switch (level) {
            case 0: 
            case 1: {
                this.slf4jLogger.debug(message);
                break;
            }
            case 2: {
                this.slf4jLogger.warn(message);
                break;
            }
            case 3: 
            case 4: {
                this.slf4jLogger.error(message);
                break;
            }
            default: {
                this.slf4jLogger.error("Was passed invalid level: {}. (Message the caller wanted to log: {})", (Object)level, (Object)message);
            }
        }
    }

    private boolean isValidLevel(int level) {
        return switch (level) {
            case 0, 1, 2, 3, 4 -> true;
            default -> false;
        };
    }

    private boolean isNotEnabled(int level) {
        return !this.isEnabled(level);
    }
}

