/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.net;

import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class CidrRange {
    private final InetAddress inetAddress;
    private final int prefixLength;
    private InetAddress startAddress;
    private InetAddress endAddress;
    private BigInteger startAddressBigInt;
    private BigInteger endAddressBigInt;

    public CidrRange(String cidr) {
        if (!cidr.contains("/")) {
            throw new IllegalArgumentException("not a valid CIDR format!");
        }
        int index = cidr.indexOf("/");
        String addressPart = cidr.substring(0, index);
        String networkPart = cidr.substring(index + 1);
        this.inetAddress = InetAddresses.forString((String)addressPart);
        this.prefixLength = Integer.parseInt(networkPart);
        this.calculate();
    }

    private void calculate() {
        int targetSize;
        ByteBuffer maskBuffer;
        if (this.inetAddress.getAddress().length == 4) {
            maskBuffer = ByteBuffer.allocate(4).putInt(-1);
            targetSize = 4;
        } else {
            maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
            targetSize = 16;
        }
        BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(this.prefixLength);
        ByteBuffer buffer = ByteBuffer.wrap(this.inetAddress.getAddress());
        BigInteger ipVal = new BigInteger(1, buffer.array());
        BigInteger startIp = ipVal.and(mask);
        BigInteger endIp = startIp.add(mask.not());
        this.startAddress = targetSize == 4 ? InetAddresses.fromIPv4BigInteger((BigInteger)startIp) : InetAddresses.fromIPv6BigInteger((BigInteger)startIp);
        this.startAddressBigInt = new BigInteger(1, this.startAddress.getAddress());
        this.endAddress = targetSize == 4 ? InetAddresses.fromIPv4BigInteger((BigInteger)endIp) : InetAddresses.fromIPv6BigInteger((BigInteger)endIp);
        this.endAddressBigInt = new BigInteger(1, this.endAddress.getAddress());
    }

    public String getNetworkAddress() {
        return this.startAddress.getHostAddress();
    }

    public String getBroadcastAddress() {
        return this.endAddress.getHostAddress();
    }

    public boolean isInRange(String ipAddress) {
        InetAddress address = InetAddresses.forString((String)ipAddress);
        return this.isInRange(address);
    }

    public boolean isInRange(InetAddress address) {
        BigInteger target = new BigInteger(1, address.getAddress());
        if (this.startAddressBigInt.compareTo(target) > 0) {
            return false;
        }
        return this.endAddressBigInt.compareTo(target) >= 0;
    }
}

